// ems simulator   5 Jan 2013
//     Prabhas Chongstitvatana

var M = [0];		// memory
var R = [0,0,0,0,0];	// registers 32
var PC, IR;
var op, a1, a2, a3, runflag, lastpc;
var int_flag, int_mask;

// ------------------ graphic display 64x64 of 5x5 pixels -----

var mycv = document.getElementById("myCanvas");
var ctx = mycv.getContext("2d");
ctx.font = "14px Arial";

function pixplot(x,y,color){
  if( color )
    ctx.fillStyle = "blue";
  else
    ctx.fillStyle = "white";
  ctx.fillRect(x,y,5,5);
}

// display text on page
function println(m){
    document.write(m + '<br>');
}

// display text on graphic screen
function grprint(m){
    ctx.fillText(m,10,300);
}

// scale to fit display 64x64 each dot is 5x5
function plot(x,y,color){
    x = x % 64;
    y = y % 64;
    pixplot(x*5,y*5,color);
}

// --------------- object code loader  --------------


// encode instruction
function enc4(op, a1, a2, a3){
    return (op << 26)| (a1 << 21) | (a2 << 16)| (a3 & 0x0ffff);
}

function loadobj(){
    var i = obj[0];
    var len = obj[1];
    var k = 2;
    while( i < len ){  // op, a1, a2, a3
        M[i] = enc4(obj[k],obj[k+1],obj[k+2],obj[k+3]);
        k += 4;
        i++;
    }
    lastpc = i;
    println('load '+ i + ' instructions');
    i = obj[k];
    len = obj[k+1];
    var end = i + len;
    k += 2;
    while( i < end ){		// data section
        M[i] = obj[k];
        i++;
        k++;
    }
}

// --------- show internal state of npu ----------

// number of cycle per instruction
var itime = [
  1,6,6,6,6,1,1,5,4,4, // ld ldd st std ud ud jal jt jf
  5,5,5,5,5,5,5,5,5,5, // addi subi muli divi andi ori xori eqi nei lti
  5,5,5,5,5,5,1,1,1,1, // lei gti gei shli shri modi ud ...
  1,1,5,5,5,5,5,5,5,5, // add sub mul div and or xor eq
  5,5,5,5,5,5,5,5,6,6, // ne lt le gt ge shl shr mod ldx stx
  4,6,6,6  	       // ret trap push pop
];

function dumpInternal(){
    println('R[1]:'+R[1]+' R[2]:'+R[2]+' R[3]:'+R[3]+' R[4]:'+R[4]);
}

// display instruction mnemonic
var mnemonic = [
  'nop','ld','ldd','st','std','ud','ud','jal','jt','jf',
  'addi','subi','muli','divi','andi','ori','xori','eqi','nei','lti',
  'lei','gti','gei','shli','shri','modi','ud','ud','ud','ud',
  'ud','ud','add','sub','mul','div','and','or','xor','eq',
  'ne','lt','le','gt','ge','shl','shr','mod','ldx','stx',
  'ret','trap','push','pop'
];

function disassem(){
    println(PC+': '+mnemonic[op]+' '+a1+' '+a2+' '+a3);
}
// ------------- timer -----------

var timer1 = 1000;
var divn = 1000;
var tm, clk;      // internal registers

// simulate a timer
function timer(flag){
    if(flag){			// init
        tm = timer1;
        clk = 0;
    }
    clk++;
    if( clk >= divn ){
        clk = 0;
        tm--;
        if( tm <= 0 ){
            int_flag = 1;	// request interrupt
            tm = timer1;	// reload counter
        }
    }
}

// -------------  s23 simulator  -------------

//  op:6 r1:5 r2:5 d:16

// a is 16-bit, sign extended
function signx(a){
    if( a & 0x08000 ) return a | 0xffff8000;
    return a;
}

// instruction decode
function opcode(){
    return ((IR >> 26) & 0x03f);
}
function disp(){
    return (IR & 0x0ffff);
}
function r1(){
    return ((IR >> 21) & 0x01f);
}
function r2(){
    return ((IR >> 16) & 0x01f);
}

function run(){		// execute one instruction

    switch( op ) {
    case 1: R[a1] = M[a3]; break;			// ld
    case 2: R[a1] = M[ R[a2] + a3]; break;   		// ldd
    case 3: M[a3] = R[a1]; break;			// st
    case 4: M[ R[a2] + a3] = R[a1]; break;		// std

    case 7: R[a1] = PC; PC = a3; break;		// jal
    case 8: if( R[a1] != 0 ) PC = a3; break;		// jt
    case 9: if( R[a1] == 0 ) PC = a3; break;		// jf

    case 10: R[a1] = R[a2] + a3; break;			// addi
    case 11: R[a1] = R[a2] - a3; break;			// subi
    case 12: R[a1] = R[a2] * a3; break;			// muli
    case 13: R[a1] = R[a2] / a3; break;			// divi
    case 14: R[a1] = R[a2] & a3; break;			// andi
    case 15: R[a1] = R[a2] | a3; break;			// ori
    case 16: R[a1] = R[a2] ^ a3; break;			// xori
    case 17: R[a1] = R[a2] == a3; break;		// eqi
    case 18: R[a1] = R[a2] != a3; break;		// nei
    case 19: R[a1] = R[a2] <  a3; break;		// lti
    case 20: R[a1] = R[a2] <= a3; break;		// lei
    case 21: R[a1] = R[a2] >  a3; break;		// gti
    case 22: R[a1] = R[a2] >= a3; break;		// gei
    case 23: R[a1] = R[a2] << a3; break;		// shli
    case 24: R[a1] = R[a2] >> a3; break;		// shri
    case 25: R[a1] = R[a2] %  a3; break;		// modi

    case 32: R[a1] = R[a2] + R[a3]; break;		// add
    case 33: R[a1] = R[a2] - R[a3]; break;		// sub
    case 34: R[a1] = R[a2] * R[a3]; break;		// mul
    case 35: R[a1] = R[a2] / R[a3]; break;		// div
    case 36: R[a1] = R[a2] & R[a3]; break;		// and
    case 37: R[a1] = R[a2] | R[a3]; break;		// or
    case 38: R[a1] = R[a2] ^ R[a3]; break;		// xor
    case 39: R[a1] = R[a2] == R[a3]; break;		// eq
    case 40: R[a1] = R[a2] != R[a3]; break;		// ne
    case 41: R[a1] = R[a2] <  R[a3]; break;		// lt
    case 42: R[a1] = R[a2] <= R[a3]; break;		// le
    case 43: R[a1] = R[a2] >  R[a3]; break;		// gt
    case 44: R[a1] = R[a2] >= R[a3]; break;		// ge
    case 45: R[a1] = R[a2] << R[a3]; break;		// shl
    case 46: R[a1] = R[a2] >> R[a3]; break;		// shr
    case 47: R[a1] = R[a2] %  R[a3]; break;		// mod

    case 48: R[a1] = M[ R[a2] + R[a3]]; break;		// ldx
    case 49: M[ R[a2] + R[a3]] = R[a1]; break;		// stx
    case 50: PC = R[a1]; break;				// ret
    case 51: trap(R[a1],a3); break;			// trap
    case 52: R[a1]++; M[R[a1]] = R[a2]; break;		// push
    case 53: R[a2] = M[R[a1]]; R[a1]--; break;		// pop

    default: error("undefine op");
    }
    R[0] = 0;
}

var icnt,cycle;

function trap(arg, num ){
    var n, c;
    switch( num ) {
    case 0:  // stop
        println(' ');
        println('execute '+icnt+' instructions '+cycle+' cycles');
        runflag = 0;
        break;
    case 1: document.write(arg+' '); break;	// print int
//	case 2: // printc
//	case 3: // print string

    case 10: timer1 = arg; break; 	// set timer
    case 11: divn = arg; break;		// set divn
    case 12: int_mask = arg; break;	// set int mask
    case 13: int_flag = 0; break;	// clear int
    case 15: plot(M[1010],M[1011],arg); break; // do graphic
    }
}

function cpusim(){
    IR = M[PC];
    op = opcode();
    a1 = r1();
    a2 = r2();
    a3 = disp();
//	disassem();
    PC++;
    run(op);
//	dumpInternal();
    cycle += itime[op];
    icnt++;
}

var int_count = 0;

function chk_int(){
    if( int_flag && int_mask ){
        int_flag = 0;	// clear int
        R[31] = PC;		// save current pc
        PC = M[1000];	// int vector
        int_count++;
    }
}

function ems(){
    int_mask = 0;  	// disable int
    int_flag = 0;  	// no int
    timer(1);		// init timer
    runflag = 1;
    while(runflag){
        cpusim()
        timer(0);
        chk_int();
    }
    println('interrupt ' + int_count);
}

function simplecpu(){
    runflag = 1;
    while(runflag){
        cpusim()
        if(icnt > 10000) runflag = 0;
    }
}

function main(){
    loadobj();
    icnt = 0;
    cycle = 0;
    PC = 0;
    simplecpu();
//  ems();
//  grprint("hello");
}

function testloader(){
    loadobj();
    for(PC = 0; PC < lastpc; PC++){
        IR = M[PC];
        op = opcode();
        a1 = r1();
        a2 = r2();
        a3 = disp();
        disassem();
    }
//	dumpInternal();
}

main();
