/*  load.c

   P. Chongstitvatana
   Department of Computer Engineering
   Chulalongkorn University
   
   modify from s1 sim 1997, 1998
   for S2 cpu simulator 5 December 2001
      
   add print, printc  to output buffer  31 Dec 2001
   refresh for s2 ver 3		5 Jan 2013
*/

#include "s23.h"

int itime[] = {
  1,6,6,6,6,1,1,5,4,4, // ld ldd st std ud ud jal jt jf 
  5,5,5,5,5,5,5,5,5,5, // addi subi muli divi andi ori xori eqi nei lti
  5,5,5,5,5,5,1,1,1,1, // lei gti gei shli shri modi ud ...
  1,1,5,5,5,5,5,5,5,5, // add sub mul div and or xor eq 
  5,5,5,5,5,5,5,5,6,6, // ne lt le gt ge shl shr mod ldx stx
  4,6,6,6  			   // ret trap push pop
};

int clock, ninst;
FILE *fp;
int ip, lastip;

extern int R[32], Ir, Pc, M[MAXMEM];
extern int runflag, savePc;

PRIVATE char ob[256];	// output buffer

void error(char *s){
	printf("error: %s at %d\n",s,Pc);
	exit(0);
}

void countclock(int op){
  clock += itime[op];
}
/*
void dump(int ads, int n){	// dump n words starting from ads
  int i;
  for(i=ads; i<ads+n; i++)
    printf("%4d %d\n",i,M[i]);
}
*/
PRIVATE int signx( int d ){		// sign bit 16 extended
	if( d & 0x08000 ) return d | 0xFFFF0000;
	return d;
}
//   instruction format    op:6 r1:5 r2:5 d:16
int IRop(void)  { return((Ir >> 26) & 0x03F);}
int IRr1(void)  { return((Ir >> 21) & 0x01F);}
int IRr2(void)  { return((Ir >> 16) & 0x01F);} 
int IRd(void)   { return( signx(Ir & 0x0FFFF));} 

extern char *cp2;

PRIVATE int geti(void){	// get one integer
  int c;
  fscanf(fp,"%d,",&c);
  return c;
}

void loadprogram(char *name){
	int op, a1, a2, a3;
	int i, ip, len;
	printf("load %s\n",name);
	fp = fopen(name,"r");
	if(fp == NULL){
		printf("input file not found");
		exit(0);
	}
	if(geti() != MAGIC){
		printf("not s2.3 object");
		exit(0);
	}
	ip = geti();		// code segment
	len = geti();
	lastip = ip + len;
	for(i = ip; i < lastip; i++ ) {
		op = geti();
		a1 = geti();
		a2 = geti();
		a3 = geti();
		M[i] = (op<<26) | (a1<<21) | (a2<<16) | (a3&0x0000FFFF); 
	}
//	printf("last address %d\n",lastip);
	ip = geti();
	len = geti();		// data segment
	for(i = ip; i < ip+len; i++)
		M[i] = geti();
}
/*
void dumpcode(void){
	int i;
	for(i = 0; i < lastip; i++){
		Ir = M[i];
		printf("%d: op %d %d %d %d\n",i,IRop(),IRr1(),IRr2(),IRd());
	}
	for(i = 100; i < 105; i++)
		printf("%d> %d\n",i,M[i]);
}
*/
static char mnemonic[][8] = {
  "nop","ld","ldd","st","std","ud","ud","jal","jt","jf",
  "addi","subi","muli","divi","andi","ori","xori","eqi","nei","lti",
  "lei","gti","gei","shli","shri","modi","ud","ud","ud","ud",
  "ud","ud","add","sub","mul","div","and","or","xor","eq",
  "ne","lt","le","gt","ge","shl","shr","mod","ldx","stx",
  "ret","trap","push","pop"
};

void disassem(void){
	int op;
	op = IRop();
	sprintf(ob,"%s %d %d %d",mnemonic[op],IRr1(),IRr2(),IRd() );
}

void show(void){		// show some registers
  int i;
  printf("PC %-4d ",savePc);
  disassem();
  for(i=strlen(ob); i<18; i++)	// pad blank to 18
	  ob[i] = 32;
  ob[i] = 0;
  printf("%s",ob);
  for(i=1;i<6;i++)
	  printf("r%d:%d ",i,R[i]);
  printf("r28:%d r29:%d r31:%d\n",R[28],R[29],R[31]);
}

