
/* S2 cpu micro architecture simulator

	P. Chongstitvatana
   Department of Computer Engineering
   Chulalongkorn University
   
   modify from s1 sim Computer Architecture 1997, 1998

   5 December 2001
   s21  18 Jan 2007
   refresh for s2.3	embed sys	5 Jan 2013

*/

#include "s23.h"

int R[32], Ir, Pc, M[MAXMEM];
int runflag, savePc;
extern char *cp2;		// output buffer

int int_flag, int_mask;
/*
int signx2( int d ){	// sign bit 21 extended
	if( d & 0x0200000 ) return d | 0xFFC00000;
	return d;
}
*/
PRIVATE int timer1 = 1000;
PRIVATE int divn = 1000;

// simulate a timer
void timer(int flag){
	static int tm;
	static int clk;
	if(flag){			// init
		tm = timer1;
		clk = 0;
	}
	clk++;
	if( clk >= divn ){
		clk = 0;
		tm--;
		if( tm <= 0 ){
			int_flag = 1;	// request interrupt
			tm = timer1;	// reload counter			
		}
	}
}

void trap(int arg, int num ){	// special function
	int n, c;
	switch( num ) {
	case 0:  // stop
		printf("stop, execute %d inst. %d clocks\n",ninst,clock);
		runflag = 0;
		break;
	case 1: // print integer
		n = sprintf(cp2,"%d", arg);
		cp2 += n;
		break;
	case 2: // printc
		n = sprintf(cp2,"%c", arg);
		cp2 += n;
		break;
	case 3: // print string
		while( (c = M[arg]) != 0){
			*cp2 = (char)c;
			arg++;
			cp2++;
		}
		break;
	case 10: timer1 = arg; break; 	// set timer
	case 11: divn = arg; break;		// set divn
	case 12: int_mask = arg; break;	// set int mask
	case 13: int_flag = 0; break;	// clear int
//	case 15: break; // do graphic
	}
}

void run(void){		// execute one instruction
	int op, a1, a2, a3;
	savePc = Pc;
	Ir = M[Pc];
	Pc++;
	op = IRop();
	a1 = IRr1();
	a2 = IRr2();
	a3 = IRd();
	countclock(op);
	ninst++;
	switch( op ) {
	case LD: R[a1] = M[a3]; break;
	case LDD: R[a1] = M[ R[a2] + a3]; break;
	case ST: M[a3] = R[a1]; break;
	case STD: M[ R[a2] + a3] = R[a1]; break;

	case JAL: R[a1] = Pc; Pc = a3; break;
	case JT: if( R[a1] != 0 ) Pc = a3; break;
	case JF: if( R[a1] == 0 ) Pc = a3; break;
	case ADDI: R[a1] = R[a2] + a3; break;
	case SUBI: R[a1] = R[a2] - a3; break;
	case MULI: R[a1] = R[a2] * a3; break;
	case DIVI: R[a1] = R[a2] / a3; break;
	case ANDI: R[a1] = R[a2] & a3; break;
	case ORI:  R[a1] = R[a2] | a3; break;
	case XORI: R[a1] = R[a2] ^ a3; break;
	case EQI: R[a1] = R[a2] == a3; break;
	case NEI: R[a1] = R[a2] != a3; break;
	case LTI: R[a1] = R[a2] <  a3; break;
	case LEI: R[a1] = R[a2] <= a3; break;
	case GTI: R[a1] = R[a2] >  a3; break;
	case GEI:  R[a1] = R[a2] >= a3; break;
	case SHLI: R[a1] = R[a2] << a3; break;
	case SHRI: R[a1] = R[a2] >> a3; break;
	
	case ADD: R[a1] = R[a2] + R[a3]; break;
	case SUB: R[a1] = R[a2] - R[a3]; break;
	case MUL: R[a1] = R[a2] * R[a3]; break;
	case DIV: R[a1] = R[a2] / R[a3]; break;
	case AND: R[a1] = R[a2] & R[a3]; break;
	case OR:  R[a1] = R[a2] | R[a3]; break;
	case XOR: R[a1] = R[a2] ^ R[a3]; break;
	case EQ: R[a1] = R[a2] == R[a3]; break;
	case NE: R[a1] = R[a2] != R[a3]; break;
	case LT: R[a1] = R[a2] <  R[a3]; break;
	case LE: R[a1] = R[a2] <= R[a3]; break;
	case GT: R[a1] = R[a2] >  R[a3]; break;
	case GE: R[a1] = R[a2] >= R[a3]; break;
	case SHL: R[a1] = R[a2] << R[a3]; break;
	case SHR: R[a1] = R[a2] >> R[a3]; break;
	
	case LDX: R[a1] = M[ R[a2] + R[a3]]; break;
	case STX: M[ R[a2] + R[a3]] = R[a1]; break;
	case RET: Pc = R[a1]; break;
	case TRAP: trap(R[a1],a3); break;
	case PUSH: R[a1]++; M[R[a1]] = R[a2]; break;
	case POP: R[a2] = M[R[a1]]; R[a1]--; break;
 
	default: error("undefine op");
	}
	R[0] = 0;
}

void chk_int(void){
	if( int_flag && int_mask ){
		int_flag = 0;	// clear int
		R[31] = Pc;		// save current pc
		Pc = M[1000];	// int vector
	}
}

void display(void);

// simulate embed sys
void ems(void){
	runflag = 1;
	while(runflag){
		run();
		timer(0);	// run timer
		chk_int();
	}
	display();
}

int main(int argc, char *argv[]){
	if( argc < 2 ) {
		printf("usage : s23 objfile\n");
		exit(0);
	}
	loadprogram(argv[1]);
//	dumpcode();
	clock = 0;
	ninst = 0;
	Pc = 0;
	R[0] = 0;
	runflag = 1;
	int_mask = 0;  	// disable int
	int_flag = 0;  	// no int
	timer(1);		// init timer
//	ems();
	shell();
	return 0;
}

