
        PUBLIC  CPU_IntDis
        PUBLIC  CPU_IntEn

        PUBLIC  CPU_SR_Save
        PUBLIC  CPU_SR_Restore

        PUBLIC  CPU_CntLeadZeros
        PUBLIC  CPU_RevBits

        PUBLIC  CPU_WaitForInt
        PUBLIC  CPU_WaitForExcept


        RSEG CODE:CODE:NOROOT(2)
        THUMB

CPU_IntDis
        CPSID   I
        BX      LR


CPU_IntEn
        CPSIE   I
        BX      LR


CPU_SR_Save
        MRS     R0, PRIMASK                     ; Set prio int mask to mask all (except faults)
        CPSID   I
        BX      LR


CPU_SR_Restore                                  ; See Note #2.
        MSR     PRIMASK, R0
        BX      LR

CPU_CntLeadZeros:
        CLZ     R0, R0                          ; Count leading zeros
        BX      LR

CPU_RevBits:
        RBIT    R0, R0                          ; Reverse bits
        BX      LR


CPU_WaitForInt:
        WFI                                     ; Wait for interrupt
        BX      LR

CPU_WaitForExcept:
        WFE                                     ; Wait for exception
        BX      LR

        END

