/* compile.c
	P.Chongstitvatana
	19 Aug 97
	1 Sept 97
	3 Apr 2001  start project RZ
	1 Jan 2002  generate s2 code
	27 Sept 2010   begin project rz3, generate parse-tree
	8 Jan 2013	gen code for s2.3
*/

#include "compile.h"

extern int pass(void);		// parse.c
extern int nsym;			// number of symbol in symbol table
FILE *FO;					// output file

void strcat2(char *s1, char *s2, char *s3){
	strcpy(s1,s2);
	strcat(s1,s3);
}

// search symbol table for Function and show it
void showParseTree(void){
	int i;
	for(i=1; i<=nsym; i++)
		if(getType(i) == tyFUNCTION || getType(i) == tyMACRO){
			printList(getRef(i));
			printf("\n");
		}
}
void showGlobal(void){
	int i, ty;
	for(i=1; i<=nsym; i++){
		ty = getType(i);
		if(ty == tySCALAR || ty == tyVECTOR){
			printf("%s type %d ref %d\n",getName(i),ty,getRef(i));
		}
	}
}
/*
void testlex(void){
	mylex();
	while( tok != tkEOF ){
		printf(" ");
		prtoken(tok);
		mylex();
	}
}
*/

// search symbol table for FUNCTION and generate its code
void genall(void){
	int i;
	for(i=1; i<=nsym; i++)
		if(getType(i) == tyFUNCTION){
			genex(getRef(i));
		}
}

void epilog(void){
	printf(".data 200\n.end\n");
}

// move c-string from strbuf to M[] at STRBASE
/*
extern char strbuf[];
extern int freestr;
int M[MAXMEM];

void dumpString(void){
	int i;
	for(i=0; i<freestr; i++)
		M[STRBASE+i] = (int)(unsigned char)strbuf[i];
}
// produce object code
void outObj(string fn){
	FO = fopen(fn,"wt");
	fprintf(FO,"%d\n",SOM_V2_MAGIC);
//	outM(CS,1,CP-1);
	dumpString();
//	outM(M,STRBASE,STRBASE+freestr-1);
	dumpSymTab();
	fclose(FO);
}
*/
void outHeader(void){
	int i, ty;
	printf(".symbol\n fp 30\n sp 29\n retval 28\n rads 27\n");
	for(i = 1; i <= nsym; i++){
		ty = getType(i);
		if(ty == tySCALAR || ty == tyVECTOR){
			printf(" %s %d\n",getName(i),getRef(i));
		}
	}
	printf(".code 0\n mov fp #3500\n mov sp #3000\n");
	printf(" jal rads main\n trap r0 #0\n");
}

int main( int argc, char *argv[] ){
	string source, code, list, iasm, name;
	char *fname;

	if( argc < 2 ) {
		printf("usage : compile source\n");
		exit(-1);
	}
	strcpy(source,argv[1]);
	strcpy(name,source);
	fname = strtok(name,".");
	if( fname == NULL ) fname = name;
	strcat2(code,fname,".obj");
//	strcat2(list,fname,".lst");
//	strcat2(iasm,fname,".s2");

	readinfile(source);
	initlex();
//	testlex();
	pass();
//	showParseTree();
//	showGlobal();
	outHeader();
	genall();
//  dumpSymTab();
	epilog();
	return 0;
}

