// add macro                        9 Feb 2013
// from macro-s.txt  macro expansion of som4.1, Aug 2008

#include "compile.h"

// return pointer to n-th ele of e
int pick(int e, int n){
	if( e == NIL ) return NIL;
	if( n < 1 ) return NIL;
	if( n == 1 ) return car(e);
	return pick(cdr(e),n-1);
}

// map atom with n-arg in e, e is the actual arg list
// sustitute get.local with n-th ele of e
int mapAtom(int a, int e){
	if( car(a) != LNAME ) return a;
	return pick(e, cdr(a)); 	// n-arg of caller
}

// e1 is the body of macro def, e2 is the actual arg list
int subst(int e1, int e2){
	if( e1 == NIL ) return NIL;
	if( isatom(e1) ) return mapAtom(e1,e2);
	if( isatom(car(e1)) )
		return cons(mapAtom(car(e1),e2), subst(cdr(e1),e2));
	return cons(subst(car(e1),e2), subst(cdr(e1),e2));
}

