// as23.h   16 Jan 2007

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define PRIVATE   static

#define NOP 0
#define LD  1		// op code number
#define LDD 2
#define ST  3
#define STD 4

#define JMP 6
#define JAL 7
#define JT  8
#define JF  9

#define ADDI 10
#define SUBI 11
#define MULI 12
#define DIVI 13
#define ANDI 14
#define ORI  15
#define XORI 16
#define EQI  17
#define NEI  18
#define LTI  19
#define LEI  20
#define GTI  21
#define GEI  22
#define SHLI 23
#define SHRI 24
#define MODI 25

#define ADD  32
#define SUB  33
#define MUL  34
#define DIV  35
#define AND  36
#define OR   37
#define XOR  38
#define EQ   39
#define NE   40
#define LT   41
#define LE   42
#define GT   43
#define GE   44
#define SHL  45
#define SHR  46
#define MOD  47
#define LDX  48
#define STX  49
#define RET  50
#define TRAP 51
#define PUSH 52
#define POP  53

#define MOVI 54
#define MOV  76		// pseudo

#define NA  108

#define SYM  110	// type of symbol
#define NUM  111
#define OP   112
#define DEND 116
#define UD   117	// type undef

#define UNDEF   0x80000000	// max neg int, denote undef in sym tab
#define	MXBUF	200			// max input line length
#define MXDAT	1000		// max no of data token
#define MAGIC   223001		// magic cookie, s2 ver 3.1

#define  MAXCODE	5000	// max size of code
#define  MAXPATCH	500 	// max no. of patch

#define eqs(a,b)  strcmp((a),(b)) == 0

//typedef struct { char type; int ref; int line; } token;
typedef struct { char type; int ref; } token;

typedef struct{
	int op;
	int arg[3];				// r1 r2 r3/ads/n
} coderec;					// code record

typedef struct{
	int ads;
	int idx;				// index to symbol table
} patchrec;					// patch list record

// hash symbol table functions from hash.c
int searchsym(char *s);
int putsym(char *s);
//int getsym(char *s,int *type);
void putvalue(int idx, int value);
void error(char *s);
int getValue(int idx);
//int getArg(int idx);
int getType(int idx);
void setsym(int idx, int value, int type);
char *getName(int idx);
