// s23.h

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define PRIVATE		static

#define LD 1		// op code number
#define LDD 2
#define ST 3
#define STD 4

#define JAL 7
#define JT 8
#define JF 9

#define ADDI 10
#define SUBI 11
#define MULI 12
#define DIVI 13
#define ANDI 14
#define ORI 15
#define XORI 16
#define EQI 17
#define NEI 18
#define LTI 19
#define LEI 20
#define GTI 21
#define GEI 22
#define SHLI 23
#define SHRI 24
#define MODI 25

#define ADD 32
#define SUB 33
#define MUL 34
#define DIV 35
#define AND 36
#define OR 37
#define XOR 38
#define EQ 39
#define NE 40
#define LT 41
#define LE 42
#define GT 43
#define GE 44
#define SHL 45
#define SHR 46
#define MOD 47

#define LDX 48
#define STX 49
#define RET 50
#define TRAP 51
#define PUSH 52
#define POP 53

#define MAXMEM		20000		// memory max
#define NIL			-1
#define MAGIC		223001		// magic cookie, s2 ver 3.1

#define eqs(a,b)  (strcmp(a,b)==0)

int IRop(void); 
int IRr1(void);
int IRr2(void);
int IRd(void);

extern int clock, ninst;

void error(char *s);
void interp(void);
void loadprogram(char *s);
void countclock(int op);
void show(void);
void trap(int arg, int num);
int signx2( int d );
