// atx1.h

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define PRIVATE   static

#define NOP 0
#define LDA 1		// op code number
#define STA 2
#define JMP 3
#define JT  4
#define JF  5
#define CALL 6

#define ADD 10
#define SUB 11
#define AND 12
#define OR 13
#define XOR 14
#define EQ 15
#define LT 16
#define LE 17
#define GT 18
#define GE 19

#define ADDI 20
#define SUBI 21
#define ANDI 22
#define ORI 23
#define XORI 24
#define EQI 25
#define LTI 26
#define LEI 27
#define GTI 28
#define GEI 29

#define MVA 30
#define MVR 31
#define LDX 32
#define STX 33
#define MVI 34
#define TRAP 35
#define RET 36
#define NOT 37

#define CLR 38
#define INC 39
#define DEC 40

#define SYM 60		// type of symbol
#define NUM 61
#define OP 62
//#define DOTS 63
#define DOTC 64
#define DOTD 65
#define DOTE 66
#define LAB  67

#define UNDEF 0x80000000	// max neg int, denote undef in sym tab
#define	MXBUF	200			// max input line length
#define MXMEM	5000		// max no of token

#define eqs(a,b)  strcmp((a),(b)) == 0

typedef struct { char type; int ref; int line; } token;

// hash symbol table functions from hash.c
int searchsym(char *s);
int putsym(char *s);
//int getsym(char *s,int *type);
void putvalue(int idx, int value);
void error(char *s);
int getValue(int idx);
int getArg(int idx);
int getType(int idx);
void setsym(int idx, int value, int type, int arg);
void dumpsymbol(void);

