//  load.c

#include "tx1.h"

FILE *fp;
int ip, lastip;

extern int R[], Ir, Pc, M[], RetAds, F, AC;
extern int runflag, savePc, lastInt;

PRIVATE char ob[256];	// output buffer

//PRIVATE sym_entry symtab[100];
//PRIVATE int nsym = 0;

void error(char *s){
	printf("error: %s at %d\n",s,Pc);
	exit(0);
}
/*
PRIVATE int signx( int d ){		// sign bit 8 extended
	if( d & 0x080 ) return d | 0xFFFFFF80;
	return d;
}
*/
// IR bits
int IRop(void)  { return((Ir & 0x0000F000) >> 12);}
int IRr1(void)  { return(Ir & 0x0000000F);}
int IRads(void) { return(Ir & 0x00000FFF);}
int IRxop(void) { return( (Ir & 0x00000F00) >> 8);}
//int IRdisp(void){ return( signx(Ir & 0x000000FF));}
int IRdisp(void){ return( Ir & 0x000000FF);}


// -----load object code from file -----

// get one charactor skip newline and blank
PRIVATE char geta(void){
  char s[32];
  fscanf(fp,"%s",s);
  return s[0] ;
}

PRIVATE int geti(void){	// get one integer
  int c;
  fscanf(fp,"%d",&c);
  return c;
}

// set maximum of number to be read to 10000
//   to prevent infinite loop when input is incorrect
void loadprogram(char *name){
	int cnt, a1, a2, a3;

	fp = fopen(name,"r");
	if(fp == NULL){
		printf("input file not found");
		exit(0);
	}
	ip = 0;
	for(cnt=0; cnt<10000; cnt++ ) {
 		switch( geta() ) {
		case 'a':
			lastip = ip;
			ip = geti();
			break;			// set address
 		case 'L':
			a1 = geti(); a2 = geti();
			M[ip] = a1<<12 | a2;
			ip++;
			break;
		case 'R':
		case 'I':
			a1 = geti(); a2 = geti(); a3 = geti();
			M[ip] = a1<<12 | a2<<8 | a3;
			ip++;
			break;
		case 'w': M[ip] = geti(); ip++; break;	// set constant data
		case 'e': cnt = 100001;	break;			// end
		default: error("incorrect object file");
		}
	}
//  loadsym();
	fclose(fp);
	printf("load program, last address %d\n",ip);
}
/*
PRIVATE void loadsym(void){
	int e, i;
	char name[32];
	e = fscanf(fp,"%s",name);
	if(e == EOF) return;
	if( name[0] != 's' ) return;
	nsym = geti();
	for(i = 0; i < nsym; i++){
		fscanf(fp,"%s",name);
		strcpy(symtab[i].name, name);
		symtab[i].value = geti();
	}
//	for(i = 0; i < nsym; i++)
//		printf("%s %d\n",symtab[i].name, symtab[i].value);
//	printf("\n");
}
*/

PRIVATE void prI(char *s) {
	sprintf(ob,"%s #%d",s,IRdisp());
}
PRIVATE void prA(char *s) {
	sprintf(ob,"%s %d",s,IRads());
}
PRIVATE void prR(char *s){
	sprintf(ob,"%s r%d",s,IRr1());
}

PRIVATE void disassem(void){
	switch( IRop() ) {
	case NOP: sprintf(ob,"nop"); break;
	case LDA: prA("ld"); break;
	case STA: prA("st"); break;
	case JMP: prA("jmp"); break;
	case JT:  prA("jt"); break;
	case JF:  prA("jf"); break;
	case CALL: prA("call"); break;

	case 13:
		switch(IRxop()){
		case CLR: prR("clr"); break;
		case INC: prR("inc"); break;
		case DEC: prR("dec"); break;
		default: sprintf(ob,"unknown op code");
		}
		break;
	case 14:
		switch(IRxop()){
		case ADD:prR("add"); break;
		case SUB:prR("sub"); break;
		case AND:prR("and"); break;
		case OR: prR("or"); break;
		case XOR:prR("xor"); break;
		case EQ: prR("eq"); break;
		case LT: prR("lt"); break;
		case LE: prR("le"); break;
		case GT: prR("gt"); break;
		case GE: prR("ge"); break;
		case MVA: prR("mva"); break;
		case MVR: prR("mvr"); break;
		case LDX: prR("ldx"); break;
		case STX: prR("stx"); break;
		default: sprintf(ob,"unknown op code");
		}
		break;

	case 15:
		switch(IRxop()){
		case ADDI:prI("addi"); break;
		case SUBI:prI("subi"); break;
		case ANDI:prI("andi"); break;
		case ORI: prI("ori"); break;
		case XORI:prI("xori"); break;
		case EQI: prI("eqi"); break;
		case LTI: prI("lti"); break;
		case LEI: prI("lei"); break;
		case GTI: prI("gti"); break;
		case GEI: prI("gei"); break;

		case MVI: prI("mvi"); break;
		case RET: sprintf(ob,"ret"); break;
		case NOT: sprintf(ob,"not"); break;
		case TRAP: prI("trap"); break;
		default: sprintf(ob,"unknown op code");
		}
		break;
	default: sprintf(ob,"unknown op code");
	}
}

void show(void){		// show some registers
	int i;

	printf("PC %4d ", savePc);
	disassem();
	for(i=strlen(ob); i<12; i++)	// pad blank
		ob[i] = 32;
	ob[i] = 0;
	printf("%s F:%d ac:%d ",ob,F,AC);
	for(i=0;i<8;i++)
		printf("r%d:%d ",i,R[i]);
	printf("r15:%d\n",R[15]);
}

void showcode(void){
	int i;
	for(i=0; i<lastip; i++){
		Ir = M[i];
		disassem();
		printf("%s\n",ob);
	}
}
