
// mon.c  monitor for command line interpreter

#include "tx1.h"

#define MXBUF  80
#define MXOBUF 2000
#define MXBP  20
#define sep  "\t\n "

extern int runflag;
extern int R[], Ir, Pc, M[];
extern int T;

int brkp = -1;						// breakpoint

char ibuf[MXBUF], *cp = NULL;		// input buffer
FILE *fi, *fo;
int disp = 0;						// display control

PRIVATE char *tok(void){	// get one token from input
	if( cp != NULL ) cp = strtok(NULL,sep);
	while ( cp == NULL ){
		printf(">");
		cp = fgets(ibuf,MXBUF,fi);
		if( cp != NULL ) cp = strtok(ibuf, sep);
	}
	cp = strupr(cp);   // convert to uppercase
// printf("%s ",cp);
	return cp;
}

PRIVATE void trace(void){
	while( runflag ) {
		sim();
		if( Pc == brkp ) break;
		if( T > XLIMIT ){
			runflag = 0;
			printf("infinite loop\n");
			break;
		}
	}
}

PRIVATE int isReg(char *s){
	int n;
	if( s[0] == 'R') {
		n = atoi(s+1);
		if( n > 0 && n < 16 ) return 1;
	}
	return 0;
}

PRIVATE void setArg(char *s, int value){
	if( isReg(s) )
		R[atoi(s+1)] = value;
	else if ( eqs(s,"PC") )
		Pc = value;
	else if ( s[0] == 'M' )
		M[atoi(s+1)] = value;
	else
		printf("set unknow argument\n");
}

PRIVATE void dumpMem(int ads, int n){
	int i,k;
	k = 0;
	printf("%4d : ",ads);
	for(i=ads;i<ads+n;i++){
		printf("%d ",M[i]);
		k++;
		if( k%10 == 0 ) printf("\n%4d : ",i+1);
	}
	printf("\n");
}

PRIVATE void help(void){
	printf("%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n",
	  "g - go",
	  "t - single step",
	  "b ads - set breakpoint",
	  "s [rn,mn,pc] v - set",
	  "d ads n - dump",
	  "r - show register",
	  "q - quit",
	  "h - help");
}

void show(void);

void interp(void){
	char *arg;
	int i, v, v2, runf;

	runf = 1;
	fi = stdin;
	while(runf){
		arg = tok();
		switch( arg[0] ){

		case 'G': trace(); break;
		case 'T': sim(); show(); break;
		case 'B': brkp = atoi(tok()); break;

		case 'S':
			arg = tok();
			v = atoi(tok());
			setArg(arg,v);
			break;
		case 'D':
			v = atoi(tok());
			v2 = atoi(tok());
			dumpMem(v,v2);
			break;

		case 'R': dumpreg(); break;
		case 'Q': runf = 0; break;
		case 'H': help(); break;
		default: printf("unknow command\n");
		}
	}
}

void dumpreg(void){
	int i;
	for(i=0; i<16; i++){
	   	if(i%8 == 0) printf("\n");
	   	printf("r%-2d:%-4d ",i,R[i]);
	}
	printf("\n");
}

/*
void testtok(){
	char *w;
	fi = stdin;
	cp = NULL;
	while(1){
		w = tok();
		printf("%s ",w);
		if( eqs(w,"QUIT")) break;
	}
}
*/
