
/* tx1 simulator

   P. Chongstitvatana
   Department of Computer Engineering
   Chulalongkorn University

   make it 8-bit arith				23 Nov 2017
*/

#include "tx1.h"

int Ir, Pc, RetAds, F, V, C;	// program is 16-bit, Pc is 12-bit
int AC, R[16], M[MAXMEM];		// byte size?
int runflag, savePc;
int T;					// global clock

void trap( int num ){	// special function

	switch( num ) {
	case 0:  // stop
		printf("stop, clock %d\n",T);
		runflag = 0;
		break;
	case 1: printf("%d ",AC); break;		// print
	case 2: printf("%c",AC); break;			// printc

	}
}

int signbit(int x){
	return x & 0x80 ? 1 : 0;
}

int signx8(int a){
	return  a & 0x080 ?  a | 0xFFFFFF00 : a;
}

// 8-bit arithmetic, add/sub on AC affect V,C
void arith(int op, int x){
	int sa, sb, sc;
	sa = signbit(AC);
	sb = signbit(x);
	switch(op){
	case ADD:
		AC += x;
		sc = signbit(AC);
		V = (sa == sb) && (sc != sa) ? 1 : 0;
		break;
	case SUB:
		AC -= x;
		sc = signbit(AC);
		V = (sa != sb) && (sc != sa) ? 1 : 0;
		break;
	}
	C = sc;
	AC &= 255;			// set to 8-bit
}

// logic operations with AC affect F
void logic(int op, int x){
	int c, d;
	c = signx8(AC);
	d = signx8(x);
	switch(op){
	case EQ:  F = c == d; break;
	case LT:  F = c < d; break;
	case LE:  F = c <= d; break;
	case GT:  F = c > d; break;
	case GE:  F = c >= d; break;
	}
}

void run(void){		// execute one instruction
	int op, xop, ads, d, r1;

	savePc = Pc;
	Ir = M[Pc];		// instruction fetch
	Pc++;
	ads = IRads();	// decode
	d = IRdisp();
	r1 = IRr1();
	op = IRop();
	xop = IRxop();
	switch( op ) {
	case NOP:  break;
	case LDA:  AC = M[ads]; break;
	case STA:  M[ads] = AC; break;
	case JMP:  Pc = ads; break;
	case JT: if( F != 0 ) Pc = ads; break;
	case JF: if( F == 0 ) Pc = ads; break;
	case CALL: RetAds = Pc; Pc = ads; break;

	case 13:
		switch( xop ){
		case CLR:
			R[r1] = 0;
			F = 1;
			break;
		case INC:
			R[r1]++;
			R[r1] &= 255;	// set to 8-bit
			F = R[r1] == 0;
			break;
		case DEC:
			R[r1]--;
			R[r1] &= 255; 	// set to 8-bit
			F = R[r1] == 0;
			break;
		}
		break;

	case 14:
		switch( xop ){
		case ADD:  arith(ADD,R[r1]); break;
		case SUB:  arith(SUB,R[r1]); break;
		case AND:  AC &= R[r1]; break;
		case OR:   AC |= R[r1]; break;
		case XOR:  AC ^= R[r1]; break;

		case EQ:
		case LT:
		case LE:
		case GT:
		case GE:  logic(xop, R[r1]); break;

		case MVA:  AC = R[r1]; break;
		case MVR:  R[r1] = AC; break;
		case LDX:  AC = M[(R[BP] << 4) + R[r1]]; break;
		case STX:  M[(R[BP] << 4) + R[r1]] = AC; break;
		default:  error("undefine xop");
		}
		break;

	case 15:
		switch( xop ){
		case ADDI: arith(ADD,d); break;
		case SUBI: arith(SUB,d); break;
		case ANDI: AC &= d; break;
		case ORI:  AC |= d; break;
		case XORI: AC ^= d; break;

		case EQI:  logic(EQ, d); break;
		case LTI:  logic(LT, d); break;
		case LEI:  logic(LE, d); break;
		case GTI:  logic(GT, d); break;
		case GEI:  logic(GE, d); break;

		case MVI:  AC = d; break;
		case RET:  Pc = RetAds; break;
		case NOT:  AC = ~AC; AC &= 255; break;
		case TRAP: trap(d); break;
		default: error("undefine xop");
		}
		break;

	default:
		error("undefine op");
	}
}

void sim(void){
	T++;
	if(runflag){
		run();
//		checkinterrupt(k);
	}
}

void initcpu(void){
	int i;
	Pc = 0;
	F = 0;
	AC = 0;
	RetAds = 0;
	for(i = 0; i < 16; i++)
		R[i] = 0;
}

void showcode(void);

int main(int argc, char *argv[]){
	if( argc < 2 ) {
		printf("usage : tx1 objfile\n");
		exit(0);
	}
	loadprogram(argv[1]);
//	showcode();
	initcpu();
	T = 0;
	runflag = 1;
	interp();
	return 0;
}

