// tx1.h

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define PRIVATE		static

#define NOP 0
#define LDA 1		// op code number
#define STA 2
#define JMP 3
#define JT  4
#define JF  5
#define CALL 6

#define ADD 0		// op 14 type R
#define SUB 1
#define AND 2
#define OR 3
#define XOR 4
#define EQ 5
#define LT 6
#define LE 7
#define GT 8
#define GE 9

#define MVA 10
#define MVR 11
#define LDX 12
#define STX 13

#define ADDI 0		// op 15 type I
#define SUBI 1
#define ANDI 2
#define ORI 3
#define XORI 4
#define EQI 5
#define LTI 6
#define LEI 7
#define GTI 8
#define GEI 9

#define MVI 10
#define TRAP 11
#define RET 12
#define NOT 13

#define CLR 0		// op 13 type R
#define INC 1
#define DEC 2

#define BP 15		// base register

#define MAXMEM		20000		// memory max
#define XLIMIT		10000		// limit number of instruction exec

#define eqs(a,b)  (strcmp(a,b)==0)

typedef struct {
	char name[32];
	int value;
} sym_entry;

// IR bits
int IRop(void);
int IRr1(void);
int IRads(void);
int IRxop(void);
int IRdisp(void);

void error(char *s);
void interp(void);
void loadprogram(char *s);
void dumpreg(void);

void sim(void);
void run();
void trap(int num);

