/*  load.c

	add print, printc  to output buffer		31 Dec 2001
	add MOS support							1 Apr 2016
	most MOS in assembly (Happy Songkran)	13 Apr 2016
	add semaphore							15 Apr 2016
*/

#include "s30.h"

FILE *fp;
int ip;

extern int NC;
extern int R[][32], Ir[], Pc[], M[];
extern int runflag[], savePc[], lastInt[];

PRIVATE char ob[256];	// output buffer

//PRIVATE sym_entry symtab[100];
//PRIVATE int nsym = 0;

void error(int k, char *s){
	printf("error: %s at %d\n",s,Pc[k]);
	exit(0);
}

PRIVATE int signx( int d ){		// sign bit 16 extended
	if( d & 0x010000 ) return d | 0xFFFE0000;
	return d;
}

// IR bits
int IRop(int k)  { return((Ir[k] & 0xF8000000) >> 27);} // bit 31..27
int IRr1(int k)  { return((Ir[k] & 0x07C00000) >> 22);} // bit 26..22
int IRads(int k) { return( Ir[k] & 0x003FFFFF       );} // bit 21..0
int IRr2(int k)  { return((Ir[k] & 0x003E0000) >> 17);} // bit 21..17
int IRr3(int k)  { return((Ir[k] & 0x0001F000) >> 12);} // bit 16..12
int IRxop(int k) { return( Ir[k] & 0x00000FFF       );} // bit 11..0
int IRdisp(int k){ return( signx(Ir[k] & 0x0001FFFF));} // bit 16..0

//extern char *cp2;

// -----load object code from file -----

// get one charactor skip newline and blank
PRIVATE char geta(void){
  char s[32];
  fscanf(fp,"%s",s);
  return s[0] ;
}

PRIVATE int geti(void){	// get one integer
  int c;
  fscanf(fp,"%d",&c);
  return c;
}

// set maximum of number to be read to 20000
//   to prevent infinite loop when input is incorrect
void loadprogram(char *name){
	int cnt, a1, a2, a3, a4, a5;

	fp = fopen(name,"r");
	if(fp == NULL){
		printf("input file not found");
		exit(0);
	}
	ip = 0;
	for(cnt=0; cnt<20000; cnt++ ) {
 		switch( geta() ) {
		case 'a': ip = geti(); break;			// set address
 		case 'L':
			a1 = geti(); a2 = geti(); a3 = geti();
			M[ip] = a1<<27 | a2<<22 | (a3&0x3FFFFF);
			ip++;
			break;
		case 'D':
			a1 = geti(); a2 = geti(); a3 = geti(); a4 = geti();
			M[ip] = a1<<27 | a2<<22 | a3<<17 | (a4&0x1FFFF);
			ip++;
			break;
		case 'X':
			a1=geti(); a2=geti(); a3=geti(); a4=geti(); a5=geti();
			M[ip] = a1<<27 | a2<<22 | a3<<17 | a4<<12 | (a5&0x0FFF);
			ip++;
			break;
		case 'w': M[ip] = geti(); ip++; break;	// set constant data
		case 'e': cnt = 200001;	break;			// end
		default: error(0,"incorrect object file");
		}
	}
//  loadsym();
	fclose(fp);
	printf("%d cores, load program, last address %d\n",NC,ip);
}
/*
PRIVATE void loadsym(void){
	int e, i;
	char name[32];
	e = fscanf(fp,"%s",name);
	if(e == EOF) return;
	if( name[0] != 's' ) return;
	nsym = geti();
	for(i = 0; i < nsym; i++){
		fscanf(fp,"%s",name);
		strcpy(symtab[i].name, name);
		symtab[i].value = geti();
	}
//	for(i = 0; i < nsym; i++)
//		printf("%s %d\n",symtab[i].name, symtab[i].value);
//	printf("\n");
}
*/
PRIVATE void pr3R(int k ,char *s){
	sprintf(ob,"%s r%d r%d r%d",s,IRr1(k),IRr2(k),IRr3(k));
}
PRIVATE void prI(int k, char *s) {
	sprintf(ob,"%s r%d r%d #%d",s,IRr1(k),IRr2(k),IRdisp(k));
}
PRIVATE void prA(int k, char *s) {
	sprintf(ob,"%s r%d %d",s,IRr1(k),IRads(k));
}
PRIVATE void pr2R(int k, char *s){
	sprintf(ob,"%s r%d r%d",s,IRr1(k),IRr2(k));
}
PRIVATE void pr1R(int k, char *s){
	sprintf(ob,"%s r%d",s,IRr1(k));
}
PRIVATE void pr1I(int k, char *s){
	sprintf(ob,"%s #%d",s,IRr1(k));
}

PRIVATE void disassem(int k){
	switch( IRop(k) ) {
	case NOP: sprintf(ob,"nop"); break;
	case LDA: prA(k,"ld"); break;
	case LDD: sprintf(ob,"ld r%d @%d r%d",IRr1(k),IRdisp(k),IRr2(k)); break;
	case STA: prA(k,"st"); break;
	case STD: sprintf(ob,"st r%d @%d r%d",IRr1(k),IRdisp(k),IRr2(k)); break;
	case JMP: sprintf(ob,"jmp %d",IRads(k)); break;
	case JAL: prA(k,"jal"); break;
	case JT:  prA(k,"jt"); break;
	case JF:  prA(k,"jf"); break;
	case MVI: sprintf(ob,"mov r%d #%d",IRr1(k),signx2(IRads(k))); break;
	case ADDI:prI(k,"add"); break;
	case SUBI:prI(k,"sub"); break;
	case MULI:prI(k,"mul"); break;
	case DIVI:prI(k,"div"); break;
	case ANDI:prI(k,"and"); break;
	case ORI: prI(k,"or"); break;
	case XORI:prI(k,"xor"); break;
	case EQI: prI(k,"eq"); break;
	case NEI: prI(k,"ne"); break;
	case LTI: prI(k,"lt"); break;
	case LEI: prI(k,"le"); break;
	case GTI: prI(k,"gt"); break;
	case GEI: prI(k,"ge"); break;
	case SHLI:prI(k,"shl"); break;
	case SHRI:prI(k,"shr"); break;
	case MODI:prI(k,"mod"); break;
	case XOP:
		switch(IRxop(k)){
		case ADD:pr3R(k,"add"); break;
		case SUB:pr3R(k,"sub"); break;
		case MUL:pr3R(k,"mul"); break;
		case DIV:pr3R(k,"div"); break;
		case AND:pr3R(k,"and"); break;
		case OR: pr3R(k,"or"); break;
		case XOR:pr3R(k,"xor"); break;
		case EQ: pr3R(k,"eq"); break;
		case NE: pr3R(k,"ne"); break;
		case LT: pr3R(k,"lt"); break;
		case LE: pr3R(k,"le"); break;
		case GT: pr3R(k,"gt"); break;
		case GE: pr3R(k,"ge"); break;
		case SHL:pr3R(k,"shl"); break;
		case SHR:pr3R(k,"shr"); break;
		case MOV: pr2R(k,"mov"); break;
		case PUSH: pr2R(k,"push"); break;
		case POP: pr2R(k,"pop"); break;
		case LDX:sprintf(ob,"ld r%d +r%d r%d",IRr1(k),IRr2(k),IRr3(k)); break;
		case STX:sprintf(ob,"st r%d +r%d r%d",IRr1(k),IRr2(k),IRr3(k)); break;
		case RET: pr1R(k,"ret"); break;
		case TRAP: sprintf(ob,"trap %d #%d",IRr1(k),IRr2(k)); break;
		case NOT: pr2R(k,"not"); break;
		case INT: pr1I(k,"int"); break;
		case RETI:sprintf(ob,"reti"); break;
		case PUSHM: pr1R(k,"pushm"); break;
		case POPM: pr1R(k,"popm"); break;
		case CID: pr1R(k,"cid"); break;
		case SIGX: pr1I(k,"sigx"); break;
		case WAITX: sprintf(ob,"waitx"); break;
		case SYNC: sprintf(ob,"sync"); break;
		case EI: sprintf(ob,"ei"); break;
		case DI: sprintf(ob,"di"); break;

		default: sprintf(ob,"unknown op code");
		}
		break;
	default: sprintf(ob,"unknown op code");
	}
}

void showK(int k){		// show some registers
	int i;

	printf("core %d: PC%4d ",k,savePc[k]);
	disassem(k);
	for(i=strlen(ob); i<18; i++)	// pad blank to 18
		ob[i] = 32;
	ob[i] = 0;
	printf("%s\n",ob);
	for(i=1;i<10;i++)
		printf("r%d:%d ",i,R[k][i]);
	printf("\n");
	for(i=20;i<30;i++)
		printf("r%d:%d ",i,R[k][i]);
	printf("\n");

}


