// s30.h

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define PRIVATE		static

#define NOP 0
#define LDA 1		// op code number
#define LDD 2
#define STA 3
#define STD 4
#define MVI 5
#define JMP 6
#define JAL 7
#define JT 8
#define JF 9
#define ADDI 10
#define SUBI 11
#define MULI 12
#define DIVI 13
#define ANDI 14
#define ORI 15
#define XORI 16
#define EQI 17
#define NEI 18
#define LTI 19
#define LEI 20
#define GTI 21
#define GEI 22
#define SHLI 23
#define SHRI 24
#define MODI 25
#define XOP 31

#define ADD 0		// xop
#define SUB 1
#define MUL 2
#define DIV 3
#define AND 4
#define OR 5
#define XOR 6
#define EQ 7
#define NE 8
#define LT 9
#define LE 10
#define GT 11
#define GE 12
#define SHL 13
#define SHR 14
#define MOD 15
#define MOV 16
#define LDX 17
#define STX 18
#define RET 19
#define TRAP 20
#define PUSH 21
#define POP 22
#define NOT 23
#define INT 24
#define RETI 25
#define PUSHM 26
#define POPM 27
#define SIGX 28
#define WAITX 29
#define CID 30
#define SYNC 31
#define EI 32
#define DI 33

#define MAXMEM		20000		// memory max
#define DEL			80			// interrupt interval (inst)
#define INTVEC		1000		// int vec location
//#define NC			2			// number of core
#define CX			16			// max number of core
#define XLIMIT		10000		// limit number of instruction exec

#define eqs(a,b)  (strcmp(a,b)==0)

typedef struct {
	char name[32];
	int value;
} sym_entry;

// IR bits
int IRop(int k); 	// bit 31..27
int IRr1(int k); 	// bit 26..22
int IRads(int k);	// bit 21..0
int IRr2(int k); 	// bit 21..17
int IRr3(int k); 	// bit 16..12
int IRxop(int k);	// bit 11..0
int IRdisp(int k);	// bit 16..0

void error(int k, char *s);
void interp(void);
void loadprogram(char *s);
int signx2( int d );
void dumpreg(void);

// mos
//int newp(void);
//int newStack(void);
//void enqueue(int p);
//void terminate(void);
//int nextp(void);
int newsem(void);
void wait(int sem);
void signal(int sem);
void interrupt(int k, int n);
//void dumpQ(void);
void sim(void);
void run(int k);
void trap(int k, int reg, int num);
int isWFI(int k);
