// io.c  peripheral for iot-rz
//   19 nov 2016

#include "s21.h"
#include <math.h>
#include <stdlib.h>

#define SINAMP    	50			// sin amplitude
#define SINLEN		1000		// sin period
#define SINMUL		2			// 10x period multiplier
#define DIGAMP		5			// square amplitude
#define DIGLEN		1000		// square period
#define DIGMUL		1			// 2x peroid multiplier
#define TIMER0DEL	150			// default timer0range
#define TIMER1DEL	200			// default timer1range

extern int clock;
extern int intmask[], intrq[];

int sinbuf[SINLEN], sinport;
int digbuf[DIGLEN], digport;
int timer0, timer1, timer0range, timer1range;

PRIVATE void gensin(void){
	double z, x;
	int i;
	z = 0.0;
	for(i = 0; i < SINLEN; i++){
		x = sin(z);					// in radian
		z = z + 0.00628318;
		x = x * (double)SINAMP;
		sinbuf[i] = (int)x;
	}
}
/*
PRIVATE void showsin(void){
	int i;
	for(i = 0; i < SINLEN; i++){
		printf("%d, ",sinbuf[i]);
		if(i%10 == 0) printf("\n");
	}
}
*/
PRIVATE int readsinport(void){
	int idx;
	idx = (clock / SINMUL) % SINLEN;
	sinport = sinbuf[idx];
	return sinport;
}

PRIVATE void gendig(void){
	int i, m;
	m = DIGLEN / 2;
	for(i = 0; i < m; i++)
		digbuf[i] = DIGAMP;
	for(i = m; i < DIGLEN; i++)
		digbuf[i] = 0;
}
/*
PRIVATE void showdig(void){
	int i;
	for(i = 0; i < DIGLEN; i++){
		if(i%10 == 0) printf("%d ",digbuf[i]);
	}
}
*/
PRIVATE int readdigport(void){
	int idx;
	idx = (clock / DIGMUL) % DIGLEN;
	digport = digbuf[idx];
	return digport;
}

void init_io(void){
	gensin();
//	showsin();
	gendig();
	srand(1);
	timer0range = TIMER0DEL;
	timer1range = TIMER1DEL;
	timer0 = 0;
	timer1 = 0;
}

PRIVATE int randomseed = 0;

PRIVATE int myrandom(void){
	randomseed = rand() & 0x7FFFFFFF;
	return randomseed;
}

void simdevices(void){
	timer0++;
	timer0 %= timer0range;
	if( timer0 == 0 ) intrq[0] = 1;
	timer1++;
	timer1 %= timer1range;
	if( timer1 == 0 ) intrq[1] = 1;
}

int readport(int n){
	switch(n){
		case 10: return readsinport();  // sin analog
		case 11: return readdigport();	// square
		case 12: return myrandom();	 	// random num
		case 13: return clock;		 	// reads clock
		default: error("read unknow port\n");
	}
	return 0;
}

