/* compile.h
	P.Chongstitvatana

	7 Nov 2005	 project som-v16
	30 Dec 2005	 som-v17
	1 Jan 2007   som-v16a for som-v24 Happy New Year!
	19 Aug 2007	 som-v31
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "icname.h"

//#define PROF
//#define DEBUG
//#define VERBOSE

#define PRIVATE			static

/* memory map
  M[ system | --> DS   | --> CS ]
            ^          ^        ^
           MAXSYS    MAXDS    MAXMEM

  SS[MAXSS]
  CS starts at  M[MAXDS]
*/

#define MAXDS           400000	// data segment
#define N_CS			50000	// size of code
#define MAXMEM			MAXDS+N_CS	// code segment
#define MAXSYS			1000	// system area
#define MAXSS			5000	// stack size
#define MAXLBUF			1000	// input line buffer
#define NAMELEN			32

/*
   system area  1 .. MAXSYS-1
   1..80   tokstring-som
   100	   CS base ads
   101 	   mode 1 interactive, 2 compile&run
   110..149 "inputfile"  som-string
   150..199 "input.lst"  som-string
   200..249 "input.obj"  som-string
*/
// som-v24 specific
#define som_src 		110
#define som_lst 		150
#define som_obj 		200
#define MODE_ADS 		101
#define OBJ_SOM40		5678940
/*
// type of identifier in symbol table
#define tyFUNC			6
#define tyLOCAL			7
#define tyGVAR			8
#define tyENUM			9
#define tyKEY			10
#define tyNEW			11
#define tyMAC			12	// macro
#define tyFULL			13	// full macro

// denote gvar arg for DS relocation
#define VSCALAR			0
#define VARRAY			1
#define VSTRING			2
*/
#define NL_CHAR			10
#define EOF_CHAR		255

// for interp.c

#define	  FALSE		0

#define   MAXFILE	20
//#define	  FREAD		0
//#define	  FWRITE	1
//#define   FRDWR		2

// -------

#define  eqs(a,b)  (strcmp(a,b) == 0)
#define  nl()		printf("\n")

typedef unsigned char uchar;

extern  int M[];			// memory
extern  int DS;				// free data pointer
extern  int CP;				// code pointer

// function prototypes

void strpack(int s1, char *s2);		// string func
void strunpack(char *s1, int s2);

void eval(int a);				// interp.c
void initfile(void);
void error(char *mess);

