/* interp.c  u-code virtual machine

	som-v31  faster sx-code			19 Aug 2007
	som-v4  u-code					24 Mar 2008

 */

#include "compile.h"

#define		PRIVATE 	static

// macro
#define 	AC		ac
#define		LV		F[a]		// local var
#define		A1		a >> 8		// first arg
#define		A2		a & 255		// second arg

// inline is 4x faster than push/pop functions
#define   pop()		SS[sp]; sp--
#define   push(x)   sp++; SS[sp] = x

/* run time environment
   define code, data, stack segments here

   system area  1 .. MAXSYS-1
   1..80   tokstring-som
*/

int M[MAXMEM];				// data and code segment
int SS[MAXSS+100];			// stack segment
int *CS = &M[MAXDS];		// relocatable code segment
int DS = MAXSYS;			// current free data segment
int fp = 1, sp = 2;			// current state of computation
int ac;						// AC
int *F;						// pointer to stack frame
FILE *filep[MAXFILE];		// store file pointer

int load_ads;				// base ads for fun "loadfile"
int cs_ads;					// base ads for CS[]

//int cnt = 0;

// switch CS between user and system
#define  user_cs()  CS = &M[M[cs_ads]]
#define  sys_cs()   CS = &M[MAXDS]

// ---------------------------

void initfile(void){
	int i;
	filep[0] = stdin;
	filep[1] = stdout;
	filep[2] = stderr;
	for(i=3; i<MAXFILE; i++)
		filep[i] = NULL;
}

void error(char *mess){
	printf("runtime error: %s\n",mess);
	exit(0);
}

// get a new file pointer, return 0 if full
PRIVATE int newfp(void){
	int i;
	for(i=3; i<MAXFILE; i++)
		if(filep[i]==NULL) return i;
	return 0;
}

// fgets(fp) and put it in M[ads]
PRIVATE void xgets(FILE *fp, int ads){
	char buf[MAXLBUF], *c;
	int i;
	c = fgets(buf,MAXLBUF,fp);
	if( c != NULL ){
		for(i=0; buf[i] != 0; i++, ads++)
			M[ads] = (int)buf[i] & 255;
		M[ads] = 0;
	}else{
		M[ads] = EOF_CHAR;
		M[ads+1] = 0;
	}
}

// static alloc memory of size a
PRIVATE int xalloc(int a){
	int b;
	b = DS;
	if( DS + a >= MAXDS )
		error("alloc: out of memory");
	DS += a;
	return b;
}
// exec syscall n
PRIVATE void xsys(int n){
	int f;
	char name[NAMELEN];

	switch(n){
	case 1: 				// pr int
		printf("%d",AC);
		break;
	case 2: 				// pr char
		printf("%c",AC);
		break;
	case 3: 				// get char
		AC = getchar();
		break;
	case 4: 				// gets
		xgets(stdin,AC);
		break;
	case 5:					// fopen fname mode
		f = pop();			// fname
		strunpack(name,f);
		f = newfp();
		if(f == 0)
			error("cannot open, too many files");
		switch(AC){			// mode
		case 0: filep[f] = fopen(name,"r"); break;
		case 1: filep[f] = fopen(name,"w"); break;
		case 2: filep[f] = fopen(name,"rw"); break;
		default: error("unknown file mode");
		}
		if(filep[f] == NULL)
			error("cannot open file");
		AC = f;				// return file pointer
		break;
	case 6:					// fclose fp
		fclose(filep[AC]);
		filep[AC] = NULL;
		break;
	case 7:					// fprint fp num
		f = pop();
		fprintf(filep[f],"%d",AC);
		break;
	case 8:					// fprintc fp c
		f = pop();
		fprintf(filep[f],"%c",AC);
		break;
	case 9:
		AC = fgetc(filep[AC]); // fgetc fp
		break;
	case 10:				// fgets fp inbuf
		f = pop();
		xgets(filep[f],AC);
		break;
/*
	case 11:				// loadfile
		strunpack(name,AC);	// file name in som-string
		loadfile(name);
		break;
*/

	case 12:				// eval im line from som
		user_cs();
		eval(AC);
		sys_cs();
		break;

//	case 13: runflag = 0;  	// halt, this is in eval()

	case 14:
		AC = xalloc(AC);
		break;
	case 15:				// exec load from user space
		sys_cs();
		eval(load_ads);
		user_cs();
		break;

	default: error("undefined syscall");
	}
}

void eval(int ref){
	int ip, op, a, b, c, d, runflag;

	ip = ref;
	runflag = 1;
	while(runflag ) {
//		cnt++;
		op = CS[ip];
		a = CS[ip+1];
		ip += 2;

		switch(op){

		case icAdd: AC += LV; break;
		case icSub: AC -= LV; break;
		case icMul: AC *= LV; break;
		case icDiv: AC /= LV; break;
		case icBand:AC &= LV; break;
		case icBor: AC |= LV; break;
		case icBxor:AC ^= LV; break;
		case icMod: AC %= LV; break;
		case icEq:  AC = AC == LV; break;
		case icNe:  AC = AC != LV; break;
		case icLt:  AC = AC <  LV; break;
		case icLe:  AC = AC <= LV; break;
		case icGt:  AC = AC >  LV; break;
		case icGe:  AC = AC >= LV; break;

		case icAddi: AC +=  a; break;
		case icSubi: AC -=  a; break;
		case icShli: AC <<= a; break;
		case icShri: AC >>= a; break;

		case icGet: AC = LV;  break;
		case icPut: LV = AC;  break;
		case icLd:	AC = M[a]; break;
		case icSt:	M[a] = AC; break;
		case icLdx: AC = M[F[A1] + F[A2]]; break;
		case icLdy: AC = M[M[A1] + F[A2]]; break;
		case icStx: M[F[A1] + F[A2]] = AC; break;
		case icSty: M[M[A1] + F[A2]] = AC; break;

		case icJmp:	ip = a;	break;
		case icJf: if(AC == FALSE) ip = a; break;
		case icJt: if(AC != FALSE) ip = a; break;

		case icCall:
/*
		sp++;
		SS[sp] = tos;		// push tos
		if (sp > MAXSS)
			error("stack overflow");
		b = xarg[a];
		SS[sp+b] = fp;
		fp = sp + b;
		sp = fp + 1;
		SS[sp] = ip;
*/
			c = CS[a+1];		// fun arity+fs
			d = c >> 8;			// arity
			if(d > 0){
				push(AC);		// last param
			}
			b = sp - d;			// new fp = sp - arity
			sp = b + (c & 255) + 2;
			if (sp > MAXSS)
				error("stack overflow");
			SS[sp-1] = fp;
			SS[sp] = ip;
			fp = b;
			ip = a + 2;
			F = &SS[fp];
			break;

		case icCallt:
			c = CS[a+1] >> 8;	// arity
			if(c > 0){
				push(AC);		// last param
				for(b = c; b > 0; b--){
					F[b] = pop();
				}
			}
			ip = a + 2;
			break;

		case icRet:				// return tos, if any
//		ip = SS[fp+1];
//		sp = fp - a;
//		fp = SS[fp];

			b = fp + a + 2;
			sp = fp;
			fp = SS[b-1];
			ip = SS[b];
			F = &SS[fp];
			break;

		case icJle: if(AC <= F[A2]) ip = A1; break;
		case icInc: LV++; AC = LV; break;
		case icDec: LV--; AC = LV; break;
		case icLit:
		case icAds:	AC = a; break;
		case icSys:
			if(a == 13) runflag = 0; else xsys(a);
			break;

		case icNot: AC = AC == FALSE; break;
		case icPush:  push(LV);  break;
		case icPusha: push(AC);  break;

		case icCase:	// A1 lo, AC hi
			b = F[A2];
			if((A1) <= b && b <= AC)
				ip += 2+(2*(b-(A1)));
			break;

		default: error("undefined opcode");
		}
	}
//	printf("noi %d\n",cnt);
}

// End

