/* som.c    main for som-language
	P. Chongstitvatana

	start Som project   			13 Sept 2003
	som-v24							1 Jan 2007 Happy New Year!
	som-v3  sx-code					3 Mar 2007
	som-v31 faster vm for sx-code	19 Aug 2007
	som-v4  u-code					24 Mar 2008

*/

#include "compile.h"
//#include <time.h>

extern int load_ads, cs_ads, *CS;

FILE *FO, *FI;			// output/input file
int cmode;				// compile mode, 0 = def, 1 = im
int load_ref;
int CP;

// make file.lst file.obj from file.xxx
PRIVATE void makename( char *src){
	int n;
	char obj[80], lst[80];
	n = strcspn(src,".");
	strncpy(obj,src,n);
	strcpy(obj+n,".obj");
	strncpy(lst,src,n);
	strcpy(lst+n,".lst");
	strpack(som_src,src);
	strpack(som_obj,obj);
	strpack(som_lst,lst);
}

PRIVATE void readCode(FILE *fi){
	int i, start, end, op, a;
	fscanf(fi,"%d%d",&start,&end);
	for(i=start; i<=end; i+=2){
		fscanf(fi,"%d%d",&op,&a);
		CS[i] = op;
		CS[i+1] = a;
	}
	CP = end+1;
}

PRIVATE void readData(FILE *fi){
	int i, start, end, c;
	fscanf(fi,"%d%d",&start,&end);
	for(i=start; i<=end; i++){
		fscanf(fi,"%d",&c);
		M[i] = c;
	}
	DS = end+1;
}

// read object file, code and data
PRIVATE void readobj(char *fn){
	int magic;
	FI = fopen(fn,"r");
	fscanf(FI,"%d",&magic);
	if(magic != OBJ_SOM40)
		error("not som 4.0 object");
	readCode(FI);
	readData(FI);
}

// read symbol to find binding of: load, cs
PRIVATE void readSym(FILE *fi){
	int i, n;
	char name[NAMELEN];
	int type,ref,arg,v;

	fscanf(fi,"%d",&n);
	for(i=0; i<n; i++){
		fscanf(fi,"%s%d%d%d%d",
			name,&type,&ref,&arg,&v);
		if(eqs(name,"loadfile"))
			load_ref = ref;
		else if(eqs(name,"CS"))
			cs_ads = ref;
	}
}

PRIVATE void genLoad(int ref){
	load_ads = CP;
	CS[CP] = icCall;
	CS[CP+1] = ref;
	CS[CP+2] = icSys;
	CS[CP+3] = 13;
	CP += 4;
}

PRIVATE void execute(char *obj){
	readobj(obj);
	fclose(FI);
	eval(2);
}

PRIVATE void doSom(void){
	readobj("som40.obj");
	printf("load som40.obj\n");
	readSym(FI);
	fclose(FI);
	genLoad(load_ref);
	eval(2);
}

// ---------- string functions ----------

// pack C-string (char *) to S-string in M[] indexed by s1
void strpack(int s1, char *s2){
	uchar c1, c2, c3, c4;
	while( *s2 != 0 ){
		c1 = (*s2 != 0) ? *s2++ : 0;
		c2 = (*s2 != 0) ? *s2++ : 0;
		c3 = (*s2 != 0) ? *s2++ : 0;
		c4 = (*s2 != 0) ? *s2++ : 0;
		M[s1] = (((((((int)c1)<<8)|(int)c2)<<8)|
			(int)c3)<<8)|(int)c4;
		s1++;
	}
	M[s1] = 0;
}

// convert som-string to C-string
void strunpack(char *s1, int s2){
	int s;
	char c1, c2, c3, c4;
	while( M[s2] != 0 ){
		s = M[s2];
		c1 = (char)((s >> 24) & 255);
		c2 = (char)((s >> 16) & 255);
		c3 = (char)((s >> 8) & 255);
		c4 = (char)(s & 255);
		if( c1 != 0 ) *s1++ = c1;
		if( c2 != 0 ) *s1++ = c2;
		if( c3 != 0 ) *s1++ = c3;
		if( c4 != 0 ) *s1++ = c4;
		s2++;
	}
	*s1 = 0;
}
/*
void prstr(int i){
	int c1,c2,c3,c4;

	while( M[i] != 0 ){
		c1 = (M[i] >> 24) & 255;
		c2 = (M[i] >> 16) & 255;
		c3 = (M[i] >> 8) & 255;
		c4 = M[i] & 255;
		if( c1 != 0 ) printf("%c",c1);
		if( c2 != 0 ) printf("%c",c2);
		if( c3 != 0 ) printf("%c",c3);
		if( c4 != 0 ) printf("%c",c4);
		i++;
	}
}
*/
// -------------------------

void Usage(void){
	printf("%s\n%s\n%s\n%s\n",
		"som40          interactive mode",
		"som40 file     compile and run, output .lst and .obj",
		"som40 -x file  execute obj file",
		"som40 -?       this help");
	exit(0);
}

// mode 1 interactive, 2 compile&run, 3 execute
int main( int argc, char *argv[] ){
	int i, mode;

	mode = 2;
	for (i=1; i<argc; i++) {
		if (argv[i][0] == '-') {
			switch (argv[i][1]) {
			case '?': Usage(); break;
			case 'x': mode = 3; break;
			default:
				fprintf(stderr,"unknown option %s\n",argv[i]);
				exit(0);
			}
		}else
			break;   // first non option
	}
	if(argc == 1) mode = 1;
	// argv[i] is the first arg, source file
	switch(mode){
	case 1:
		initfile();
		M[MODE_ADS] = 1;
		doSom();
		break;
	case 2:
		initfile();
		M[MODE_ADS] = 2;
		makename(argv[i]);
		doSom();
		break;
	case 3:
		initfile();
		execute(argv[i]);
		break;
	}
	return 0;
}
