// lex.c    tokeniser  from project som 4.2a  "lex2.c"
//     20 Mar 2012

#include <stdio.h>

#define MAXBUF      1000        // input buffer size
#define eol         10
#define eof         -1
#define isSpace(c)  (int)spaceQ[((int)(c))&255]
#define isAlNum(c)  (int)alnumQ[((int)(c))&255]

#define tkEOF  		20
#define tkSYM		30

extern FILE *FO, *FI;			// output, input file

static char spaceQ[256] = {
0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,1,1,1,1,0};

static char alnumQ[256] = {
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

char buf[MAXBUF+5];	            // input buffer, one line
int TP;                         // current token pointer
int line;
char tokstring[100];			// current token

// leave TP after the end of the current token
// return token value (tok) and tokstring[.]

int lex(FILE *fi){
	char *t, *p, c, d;
	int tok, pos;

	// skip blank, if input is empty, read a line
	pos = TP;
	while( isSpace(buf[pos]))
		pos++;
	// while isEmpty or isComment, read and skip space
	while(buf[pos] == 0 || buf[pos] == ';'){
		p = fgets(buf,MAXBUF,fi);	    // read one line
		if( p == NULL )
			buf[0] = eof;
		line++;
		pos = 0;
		while( isSpace(buf[pos]) )		// 0 is not space!
			pos++;
	}

	c = buf[pos];				// current char
	d = buf[pos+1];				// lookahead
	pos++;						// pos is now at d

	// collect string
	tokstring[0] = 0;			// clear tokstring
	t = tokstring;
	switch( c ){
	case eof:
		buf[pos] = 0;			// force read next time
		tok = tkEOF;
		break;

	default:
		*t = c;
		t++;
		while( isAlNum(d) ){
			*t = d;
			t++;
			pos++;
			d = buf[pos];
		}
		*t = 0;					   // terminate
		tok = tkSYM;
		break;
	}
	TP = pos;
	return tok;
}
/*
void testlex(void){
	int oldline, tok;
	int i;

	FI = fopen("test.txt","r");
	TP = 0; line = 0; buf[0] = 0;
	tok = lex(FI);
	while( tok != tkEOF ){
		if(oldline != line){
			printf("\n");
			oldline = line;
		}
		printf("%s ",tokstring);
		tok = lex(FI);
	}
	fclose(FI);
	printf("\nline %d\n",line);
}

void initlex(void){
	int i;
	for(i=0; i<255; i++) spaceQ[i] = 1;
	for(i=33; i<127; i++) spaceQ[i] = 0;
	spaceQ[255] = 0;            // eof
	TP = 0;
	printf("spaceQ[] = {\n");
	for(i=0; i<255; i++){
		printf("%d,",spaceQ[i]);
		if( (i % 40) == 0) printf("\n");
	}
}

void initlex(void){
	int i;
	for(i=0; i<255; i++) alnumQ[i] = 0;
	for(i='0'; i<='9'; i++) alnumQ[i] = 1;
	for(i='A'; i<='Z'; i++) alnumQ[i] = 1;
	for(i='a'; i<='z'; i++) alnumQ[i] = 1;
	alnumQ['-'] = 1;
	alnumQ['_'] = 1;
	printf("alnumQ[] = {\n");
	for(i=0; i<=255; i++){
		printf("%d,",alnumQ[i]);
		if( (i % 40) == 0) printf("\n");
	}
}
*/

