// project NPU  (natural GPU)
//    	P. Chongstitvatana   19 Mar 2012
//		version 2 isa        16 Dec 2012
//  npu.h

#include <stdio.h>

#define   MAGIC   9806542		// magic cookie, npu4 object file

// npu instruction set
// instruction format
//
// op:8 a1:14 a2:5 a3:5
//
// a1: ads,n 14 bits
// a2: ls 0,1,2,3
// a1,a2,a3: r 0..31
//
// ld ls @ads		LDS[ls] = M[ads]     ls = 0,1,2,3
// st ls @ads		M[ads] = LDS[ls]
// ldr r 			R[r] = LDS	     r = 0..31
// str r            LDS = R[r]
// ldx ls r1 r2     LDS[ls] = M[R[ls][r1]+R[ls][r2]]
// stx ls r1 r2     M[R[ls][r1]+R[ls][r2]] = LDS[ls]
// ldw @ads			LDS = M[ads]         load wide
// bc r ls		 	R[r] = LDS[ls]       broadcast

// add r3 r1 r2		R[r3] = R[r1] + R[r2]
// sub r3 r1 r2     R[r3] = R[r1] - R[r2]
// mul r3 r1 r2     R[r3] = R[r1] * R[r2]
// ashr r3 r1 #n    R[r3] = R[r1] >> n
// addi r3 r1 #n    R[r3] = R[r1] + n
// and r3 r1 r2     R[r3] = R[r1] and R[r2]
// or  r3 r1 r2     R[r3] = R[r1] or  R[r2]
// xor r3 r1 r2     R[r3] = R[r1] xor R[r2]
// lt r3 r1 r2      R[r3] = R[r1] <  R[r2]
// le r3 r1 r2      R[r3] = R[r1] <= R[r2]
// eq r3 r1 r2 		R[r3] = R[r1] == R[r2]

// jmp @ads			pc = ads
// jz r @ads		if R[r] == 0, pc = ads
// jnz r @ads		if R[r] != 0, pc = ads

// rnd r			R[r] = random
// mv_t r3 r1 r2	if R[r3] != 0, R[r1] = R[r2]  move if true

// pseudo

// sys 4 0			stop simulation

// equivalent

// inc r			addi r r #1
// dec r			subi r r #1
// clr r            xor r r r
// mov r3 r1        addi r3 r1 #0

#define  xLd	10
#define  xSt	11
#define  xLdr	12
#define  xStr	13
#define  xLdx	14
#define  xStx	15
#define  xLdw	16
#define  xBc	17
#define  xAdd	18
#define  xSub	19
#define  xMul	20
#define  xAshr	21
#define  xAddi	22
#define  xAnd	23
#define  xOr	24
#define  xXor	25
#define  xLt	26
#define  xLe	27
#define  xEq	28

#define  xJmp	29
#define  xJz	30
#define  xJnz	31
#define  xRnd	32
#define  xMvt	33		// move if true
#define  xSys	34

#define  xInc	35     // use addi r r 1
#define  xDec	36     // use subi r r 1
#define  xClr	37     // use addi r r 1
#define  xMov	38	   // use addi r r 0


