// data.c
//		create grammar and lexicon
//		18 Nov 2012

#include "ailib.h"
#include "parse.h"

PRIVATE void printstring(int a){
	printf("%c%s%c", 34,get_string(a),34);
}

PRIVATE void print_atom(int a){
	switch( head(a) ){
	case TYNAME: printstring(a); break;
	case TYNUMBER: printf("%d",tail(a)); break;
	case TYLEX:
	case TYRULE:
			switch(tail(a)){
			case S:	printf("S"); break;
			case NP: printf("NP"); break;
			case VP: printf("VP"); break;
			case ART: printf("ART"); break;
			case N: printf("N"); break;
			case V: printf("V"); break;
			case ADJ: printf("ADJ"); break;
			}
			break;
	}
}

void print_list(int a){
	if( a == NIL ) return;
	if( isatom(a) ){
		print_atom(a);
		printf(" ");
	}else{
		printf("(");
		while(a != NIL){
			print_list(head(a));
			a = tail(a);
		}
		printf(")");
	}
}

int atom_eq(int a, int b){
	return (head(a) == head(b)) && (tail(a) == tail(b));
}

int name_eq(int a, int b){
	return (head(a) == head(b)) &&
		(strcmp(get_string(a),get_string(b)) == 0);
}

PRIVATE int makerule(int rule){
	return newcell(TYRULE,rule);
}

PRIVATE int makelex(int name){
	return newcell(TYLEX,name);
}

// grammar:
//    S -> NP VP
//    NP -> ART N
//    NP -> ART ADJ N
//    VP -> V
//    VP -> V NP

int makegrammar(void){
	int a, b, c, d, e, f;
	a = cons(makerule(NP),cons(makerule(VP),NIL));
	a = cons(makerule(S),list(a));
	b = cons(makelex(ADJ),cons(makelex(N),NIL));
	b = cons(makelex(ART),b);
	c = cons(makelex(ART),cons(makelex(N),NIL));
	c = cons(c,list(b));
	c = cons(makerule(NP),c);
	d = cons(makelex(V),NIL);
	e = cons(makelex(V),cons(makerule(NP),NIL));
	e = cons(makerule(VP),cons(d,list(e)));
	f = cons(a,cons(c,list(e)));
//	print_list(f);
	return f;
}

//  lexicon:
//    cried: V
//    dogs: N, V
//    the: ART
//    old: N, ADJ
//    man: N, V

int makevocab(void){
	int a, b, c, d, e;
	a = cons(name("cried"), cons(name("dogs"),NIL));
	a = cons(name("man"),a);
	a = cons(makelex(V),list(a));
	b = cons(name("dogs"), cons(name("old"),NIL));
	b = cons(name("man"),b);
	b = cons(makelex(N),list(b));
	c = cons(name("the"),NIL);
	c = cons(makelex(ART),list(c));
	d = cons(name("old"),NIL);
	d = cons(makelex(ADJ),list(d));
	e = cons(c,list(d));
	e = cons(a,cons(b,e));
//	print_list(e);
	return e;
}

// example of reading static string into data structure
PRIVATE char inputstring[][10] = {
//	"the", "dogs", "cried", 0
	"the", "old", "man", "cried", 0
};

int makeinput(void){
	int a = NIL, i = 0;
	char *c;
	c = inputstring[i];
	while( *c != 0 ){
		a = cons(name(c),a);
		i++;
		c = inputstring[i];
	}
	return revlist(a);
}

extern int input;
// make start state  ( (S) ("input..") )
int makestate(void){
	return list(cons(list(makerule(S)),list(input)));
}

