#include "ailib.h"

int make_list(void){
   return cons(number(1), cons(number(2), cons(number(3), cons(number(4), NIL))));
}

int len(int ls){
  if(ls == NIL) return 0;
  else return 1 + len(tail(ls));
}

void test_len(void){
  int a;
  a = make_list();
  printf("%d\n", len(a));
}

int len2(int ls){
  if(ls == NIL) return 0;
  if(isatom(ls)) return 1;
  else return len2(head(ls)) + len2(tail(ls));
}

int make_complex_list(void){
  int a, b;
  a = cons(number(1),cons(number(2),NIL));
  b = cons(number(3),cons(number(4),NIL));
  return cons(a, cons(b, NIL));
}

void test_len_complex(void){
  int a;
  a = make_complex_list();
  printf("%d\n", len(a));
  printf("%d\n", len2(a));
}

int copy_list(int ls){
  if(ls == NIL) return NIL;
  else return cons(clone_atom(head(ls)), copy_list(tail(ls)));
}

void test_copy(void){
  int a, b;
  a = make_list();
  b = copy_list(a);
  print_list(b);
}

int copy_list_complex(int ls){
  if(ls == NIL) return NIL;
  if(isatom(ls)) return clone_atom(ls);
  else return cons( copy_list_complex(head(ls)),copy_list_complex(tail(ls)));
}

void test_copy_complex(void){
  int a, b;
  a = make_complex_list();
  b = copy_list_complex(a);
  print_list(b);
}

/*
int main(void){
//  print_list( make_list() );
//  test_len();
//  test_len_complex();
//  test_copy();
  test_copy_complex();
}
*/
