
// merge-subs.c
//     simple version of merge and substitute   18 Nov 2012

int merge2(int ls1, int ls2);

// merge two lists into one
int merge(int ls1, int ls2){
	return merge2(revlist(ls1),ls2);
}

int merge2(int ls1, int ls2){
	if( ls1 == NIL ) return ls2;
	return merge2(tail(ls1),cons(head(ls1),ls2));
}

int testmerge(void){
	int a, b, c;
	a = cons(number(1),cons(number(2),NIL));
	b = cons(number(3),cons(number(4),NIL));
	print_list(a); nl();
	print_list(b); nl();
	c = merge(a,b);
	print_list(c); nl();
	return 0;
}

int subs2(int rules, int state);

int subs(int state){
	int rhs;
	rhs = asso(head(state),grammar);
	return subs2(rhs,tail(state));
}

int subs2(int rules, int state){
	if( rules == NIL ) return NIL;
	return cons(merge(head(rules),state),
		subs2(tail(rules),state));
}

void testsubs(void){
	int a, b, c, d;
	a = head(tail(head(grammar)));	// (NP VP)
//	print_list(a);
	c = subs(a);
	print_list(c);
}
