// parse.c
//    natural language top-down parser
//    per Boonserm teaching slides
//    Prabhas Chongstitvatana
//    17 Nov 2012

#include "ailib.h"
#include "parse.h"

#define   MAXSTK	1000
#define   YES		1
#define   NO        0

#define   top()		(pstk[psp])		// top of parse stack

typedef struct{
    int choice;
    int input;
    int alt;
}  citem;				// item in choice stack

PRIVATE int pstk[MAXSTK];		// parse stack
PRIVATE int psp = 0;
PRIVATE citem cstk[MAXSTK];		// choice stack
PRIVATE int csp = 0;
int input, grammar, lexicon, state;

void error(char *mess){
    printf("%s\n",mess);
    exit(0);
}

PRIVATE void pushp(int a){
    if( psp >= MAXSTK ) error("pstack overflow");
    psp++;
    pstk[psp] = a;
}

PRIVATE void popp(void){
    if( psp == 0 ) error("pstack underflow");
    psp--;
}

PRIVATE void pushc(int choice, int input, int alt){
    if( csp >= MAXSTK ) error("cstack overflow");
    csp++;
    cstk[csp].choice = choice;
    cstk[csp].input = input;
    cstk[csp].alt = alt;
}

PRIVATE void popc(void){
    if( csp == 0 ) error("cstack underflow");
    csp--;
}

void init(void){
    grammar = makegrammar();
    lexicon = makevocab();
    input = makeinput();
//    pushp(NIL);			// bottom of parse stack
	state = makestate();
}

int isrule(int a){
    return head(a) == TYRULE;
}

int islex(int a){
    return head(a) == TYLEX;
}

// return item associate with key from ls
int asso(int key, int ls){
    int a;
    if( ls == NIL ) return NIL;
    a = head(ls);
    if( atom_eq(key,head(a)) ) return tail(a);
    return asso(key,tail(ls));
}

// match w to any words in set v (lexicon)
int match(int v, int w){
    if( v == NIL ) return NO;
    if( name_eq(head(v),w) ) return YES;
    return match(tail(v),w);
}

// push all rules in ls to parse stack
void pushrule(int ls){
    int b;
    b = revlist(ls);
    while(b != NIL){
        pushp(head(b));
        b = tail(b);
    }
}

PRIVATE void print_pstk(void){
    int i;
    for(i = psp; i > 0; i--){
        print_list(pstk[i]);
        nl();
    }
}

PRIVATE void print_cstk(void){
    int i;
    for(i = csp; i > 0; i--){
        printf("choice:%d in:",cstk[i].choice);
        print_list(cstk[i].input);
        printf(" alt: ");
        print_list(cstk[i].alt);
        nl();
    }
}

PRIVATE void dumpstate(void){
    printf("----\n");
    print_pstk();
    print_cstk();
    printf("----\n");
}

PRIVATE void print_rule(int lhs, int rhs){
    printf("rule: ");
    print_list(lhs);
    printf("-> ");
    print_list(rhs);
    nl();
}

PRIVATE void print_lex(int lhs, int rhs){
    printf("lex: ");
    print_list(lhs);
    printf("-> ");
    print_list(rhs);
    nl();
}
/*
PRIVATE void print_match(void){
    printf("match: ");
    print_list(head(input));
    printf(" next input ");
    print_list(tail(input));
    nl();
}
*/

void print_match(int w){
	printf("match: ");
	print_list(w); 
	nl();
}

PRIVATE int cnt = 0;
/*
int parse(void){
    int t, rhs, alt;
    if( cnt++ > 20 ) exit(0);
    t = top();
    if( t == NIL ){
        return  input == NIL ? YES : NO;
    }else if( isrule(t) ){
        popp();
        rhs = asso(t,grammar);
        print_rule(t,rhs);
        pushc(psp,input,tail(rhs));		// alt2..
        pushrule(head(rhs));			// alt1
    }else if( islex(t) ){
        rhs = head(asso(t,lexicon));
        print_lex(t,rhs);
        if( match(rhs,head(input)) ){
            print_match();
            popp();						// parse next rule
            input = tail(input);		// next input
        }else{
            alt = cstk[csp].alt;		// do alternative
            if( alt == NIL ){			// fail
                psp = cstk[csp].choice;	// restore choice
                input = cstk[csp].input;// backup input
                popc();
            }else{						// alternative
                pushp(head(alt));
                cstk[csp].alt = tail(alt);
            }
        }
    }
    dumpstate();
    return parse();
}
*/
int merge2(int ls1, int ls2);

// merge two lists into one
int merge(int ls1, int ls2){
	return merge2(revlist(ls1),ls2);
}

int merge2(int ls1, int ls2){
	if( ls1 == NIL ) return ls2;
	return merge2(tail(ls1),cons(head(ls1),ls2));
}

int testmerge(void){
	int a, b, c;
	a = cons(number(1),cons(number(2),NIL));
	b = cons(number(3),cons(number(4),NIL));
	print_list(a); nl();
	print_list(b); nl();
	c = merge(a,b);
	print_list(c); nl();
	return 0;
}
/*
int subs2(int rules, int state);

int subs(int state){
	int rhs;
	rhs = asso(head(state),grammar);
	return subs2(rhs,tail(state));
}

int subs2(int rules, int state){
	if( rules == NIL ) return NIL;
	return cons(merge(head(rules),state),
		subs2(tail(rules),state));
}

void testsubs(void){
	int a, b, c, d;
	a = head(tail(head(grammar)));	// (NP VP)
	print_list(a);
	c = subs(a);
	print_list(c);
}
*/

int subs2(int rules, int state, int inp);

int subs(int state, int inp){
	int rhs;
	rhs = asso(head(state),grammar);
	return subs2(rhs,tail(state),inp);
}

int subs2(int rules, int state, int inp){
	int a, s;
	if( rules == NIL ) return NIL;
	a = merge(head(rules),state);
	s = cons(a,list(inp));
	return cons(s,subs2(tail(rules),state,inp));
}

void testsubs(void){
	int a, b, c, d;
	a = head(tail(head(grammar)));	// (NP VP)
	b = cons(a,list(input));
	print_list(b); nl();
	c = subs(a,input);
//	print_list(c); nl();
	print_list(head(c)); nl();
	print_list(tail(c)); nl();
//	print_list(state);
	a = head(state);
	print_list(head(a));
	print_list(tail(a));
	printf("sucess %d\n",success(state));
}

// check success ( NIL, NIL)
int success(int s){
	return (head(s) == NIL) && (tail(s) == NIL);
}

int parse2(int s){
	int s1, in, rule, t, rhs;
	printf(">>");
	print_list(s); nl();
	if( cnt++ > 15 ) exit(0);
	if( s == NIL ) return NO;
	if( success(s) ) return YES;
	
	//  generate next state
	s1 = head(s);		// s1, current state  (rule in)
	rule = head(s1);
	in = head(tail(s1));
	t = head(rule);		// first symbol
	if( islex(t) ){
		rhs = head(asso(t,lexicon));
		print_lex(t,rhs);
        if( match(rhs,head(in)) ){
        	print_match(head(in));
			// remove first symbol and move input
			s1 = cons(tail(rule),list(tail(in)));
			s = cons(s1,tail(s));
		}else{
			// backup
			s = tail(s);
		}
	}else if( isrule(t) ){
		s1 = subs(rule,in);
		s = merge(s1,tail(s));
	}else
		// back up
		s = tail(s);
		
	return parse2(s);
}

int main(void){
    init();
/*
    pushp(head(head(grammar))); // starting rule
    if( parse() )
        printf("yes");
    else
        printf("no");
*/
//	testmerge();
//	testsubs();
	parse2(state);
    return 0;
}
