// example of building parse tree

// ex.c

#include "compile.h"

#define tPLUS	53
#define tMINUS  52
#define tLPAR   68
#define tRPAR   69
#define tID     10

// return 0 -- error, 1 -- ok

int ex(void);

void prtok(int tk){
	switch( tk ){
	case tPLUS:  printf("+"); break;
	case tMINUS: printf("-"); break;
	case tLPAR:  printf("("); break;
	case tRPAR:  printf(")"); break;
	case tID:    printf("id"); break;
	}
}

void mylex2(void){
	mylex();
	printf(" ");
	prtok(tok);
}

int match(int mytok){
	if( tok == mytok ){
		mylex2();
		return 1;
	}
	return 0;
}

//  in the first step, we define pure parser

int op(void){
	if( tok == tPLUS ) match(tPLUS);
	else if( tok == tMINUS ) match(tMINUS);
	return 0;
}

int term2(void){
	if( tok == tLPAR ){
		match(tLPAR);
		ex();
		return match(tRPAR);
	}else if( tok == tID ){
		return match(tID);
	}else
		return 0;
}

int ex(void){
	term2();
	if( tok == tPLUS || tok == tMINUS ){
		op();
		return term2();
	}
	return 1;
}

//   that the end of pure parser

//   next we include action routines into parser

int zpop(void);

int op3(void){
	if( tok == tPLUS ){
		match(tPLUS);
		zpush(newatom(1,tPLUS));
		return 1;
	}else if( tok == tMINUS ){
		match(tMINUS);
		zpush(newatom(1,tMINUS));
		return 1;
	}
	return 0;
}

int term3(void){
	if( tok == tLPAR ){
		match(tLPAR);
		ex3();
		match(tRPAR);
		makebintree();
		return 1;
	}else if( tok == tID ){
		match(tID);
		ypush(newatom(1,tID));
		return 1;
	}else
		return 0;
}

int ex3(void){
	term3();
	if( tok == tPLUS || tok == tMINUS ){
		op3();
		return term3();
	}
	return 1;
}

void makebintree(void){
	int a, b, c, op;
	b = ypop();
	a = ypop();
	op = zpop();
	c = cons(op, cons(a,cons(b,NIL)));
	ypush(c);
}

// here is a function to print out the parse tree

void prTree(int a){
    if( a == NIL ) return;
    if( isatom(a) ){
        prtok(cdr(a));
        printf(" ");
    }else{
		printf("(");
		while( a != NIL ){
			prTree(car(a));
			a = cdr(a);
		}
		printf(")");
	}
}

