/* stmt.c
	P. Chongstitvatana		25 Aug 97

	start project RZ							3 Apr 2001
	incorporate dcl.c into stmt.c
	  and change to one pass					3 Jan 2002
	modify to untangle parsing parameters
	  in function call and use string stack		17 Oct 2010
	clean up for ex-parse-tree in ex.c			21 Nov 2017
*/

#include "compile.h"

#define MAXYSTK  	2000
#define MAXZSTK  	100
#define MAXSTRBUF 	5000

extern int lv;							// symtab.c

int pv;
char strbuf[MAXSTRBUF];					//  string buffer
int freestr = 0;						//  index to free string

int ystack[MAXYSTK], ysp = 0;  	// 	parser stack
int zstack[MAXZSTK], zsp = 0;   //  operator stack


void seterror( char *mess ){
	printf("line %d near '%s' : %s\n",line,tokstring,mess);
//  dumpSym2();
	exit(-1);
}


// -------------- parser stack operator ----------

void ypush(int x){
	ysp++;
	if( ysp >= MAXYSTK )
		seterror("parser stack overflow");
	ystack[ysp] = x;
}

int ypop(void){
	int x;
	if( ysp <= 0 )
		seterror("parser stack underflow");
	x = ystack[ysp];
	ysp--;
	return x;
}

int ytos(void){
	return ystack[ysp];
}


// ------ bop operator stack -----------

void zpush(int op){
	zsp++;
	if( zsp >= MAXZSTK )
		seterror("operator stack overflow");
	zstack[zsp] = op;
}

int zpop(void){
	int x;
	if( zsp <= 0 )
		seterror("operator stack underflow");
	x = zstack[zsp];
	zsp--;
	return x;
}

int ztos(void){
	return zstack[zsp];
}

// end


