/*  load.c

   for S2 cpu simulator
   5 December 2001
   modify from s1 sim 1997, 1998

   supporting function

   P. Chongstitvatana
   Department of Computer Engineering
   Chulalongkorn University
	add print, printc  to output buffer  31 Dec 2001
*/

#include "s2.h"

int itime[] = {
6,6,4,6,6,4,5,		/* lda ldd ldi sta std jmp jal */
5,5,5,5,5,5,5, 		/* addi subi muli divi andi ori xori */
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1, /* 17 undef */
5,5,5,5,5,5,5,5,5,	/* add sub mul div and or xor shl shr */
6,6,4,4  			/* ldx stx jr trap */
};

int clock, ninst;
FILE *fp;

extern int R[32], Ir, Mdr, Mar, Pc, T, Z, S, M[20000];
extern int runflag, savePc;

void error(char *s){
	printf("error: %s\n",s);
	exit(0);
}

void countclock(){
  int i;
  if( IRop() == 31 )
    i = 31 + IRxop();
  else
  	i = IRop();
  clock += itime[i];
  ninst++;
}

void dump(int ads, int n){	/* dump n words starting from ads */
  int i;
  for(i=ads; i<ads+n; i++)
    printf("%4d %d\n",i,M[i]);
}

void report(){
  float cpi;
  if( ninst == 0 )
	  printf("0 instruction\n");
  else {
  	  cpi = ((float) clock)/ninst;
  	  printf("%d instructions, %d clocks, CPI %4.2f\n",ninst,clock,cpi);
  }
}

int signx( int d ){		/* sign bit 16 extended */
	if( d & 0x010000 ) return d | 0xFFFE0000;
	return d;
}

/* IR bits */
int IRop()  { return( ( Ir & 0xF8000000 ) >> 27 ); } /* bit 31..27 */
int IRr1()  { return( ( Ir & 0x07C00000 ) >> 22 ); } /* bit 26..22 */
int IRads() { return(   Ir & 0x003FFFFF         ); } /* bit 21..0  */
int IRr2()  { return( ( Ir & 0x003E0000 ) >> 17 ); } /* bit 21..17 */
int IRr3()  { return( ( Ir & 0x0001F000 ) >> 12 ); } /* bit 16..12 */
int IRxop() { return(   Ir & 0x00000FFF         ); } /* bit 11..0  */
int IRdisp(){ return( signx(Ir & 0x0001FFFF)    ); } /* bit 16..0  */

extern char *cp2;

void trap( int num, int rn ){		/* special function */
  int n;
  switch( num ) {
  case 0 :  // stop
	  report();
	  runflag = 0;
	  break;
  case 1 : // print integer
  	  n = sprintf(cp2,"%d", R[rn]);
	  cp2 += n;
	  break;
  case 2 : // printc
	  n = sprintf(cp2,"%c", R[rn]);
	  cp2 += n;
	  break;
  }
}

/* load object code from file */

char geta(){	/* get one charactor skip newline and blank */
  char s[32];
  fscanf(fp,"%s",s);
  return s[0] ;
}

int geti(){	/* get one integer */
  int c;
  fscanf(fp,"%d",&c);
  return c;
}

/* set maximum of number to be read to 20000
   to prevent infinite loop when input is incorrect
*/
void loadprogram(char *name){
  int cnt,ip;
  fp = fopen(name,"r");
  if(fp == NULL){
	 printf("input file not found");
	 exit(0);
  }
  ip = 0;
  for(cnt=0; cnt<20000; cnt++ ) {
    switch( geta() ) {
    case 'a': ip = geti(); break;		  		/* set address */
    case 'L': M[ip] = geti()<<27 | geti()<<22 |
				(geti()&0x3FFFFF); ip++; break;
	case 'D': M[ip] = geti()<<27 | geti()<<22 | geti()<<17 |
				(geti()&0x1FFFF); ip++; break;
	case 'X': M[ip] = geti()<<27 | geti()<<22 | geti()<<17 | geti()<<12 |
				(geti()&0x0FFF); ip++; break;
    case 'w': M[ip] = geti(); ip++; break;		/* set constant data */
    case 'e': cnt = 200001;	break;	/* end */
	default: error("incorrect object file");
    }
  }
  fclose(fp);
  printf("load program, last address %d\n",ip);
}

void pr3R(char *s){ printf("%s r%d r%d r%d",s,IRr1(),IRr2(),IRr3()); }
void prI(char *s) { printf("%s r%d r%d #%d",s,IRr1(),IRr2(),IRdisp()); }
void pr2R(char *s){ printf("%s r%d r%d",s,IRr1(),IRr2()); }

void disassem(){
	switch( IRop() ) {
	case LDA: printf("ld r%d %d",IRr1(),IRads()); break;
	case LDD: printf("ld r%d @%d r%d",IRr1(),IRdisp(),IRr2()); break;
	case LDI: printf("ld r%d #%d",IRr1(),IRads()); break;
	case STA: printf("st %d r%d",IRads(),IRr1()); break;
	case STD: printf("st @%d r%d r%d",IRdisp(),IRr2(),IRr1()); break;
	case JMP: printf("jmp %d %d",IRr1(),IRads()); break;
	case JAL: printf("jal r%d %d",IRr1(),IRads()); break;
	case ADDI:prI("add"); break;
	case SUBI:prI("sub"); break;
	case MULI:prI("mul"); break;
	case DIVI:prI("div"); break;
	case ANDI:prI("and"); break;
	case ORI: prI("or"); break;
	case XORI:prI("xor"); break;
	case XOP:
		switch(IRxop()){
		case ADD:pr3R("add"); break;
		case SUB:pr3R("sub"); break;
		case MUL:pr3R("mul"); break;
		case DIV:pr3R("div"); break;
		case AND:pr3R("and"); break;
		case OR: pr3R("or"); break;
		case XOR:pr3R("xor"); break;
		case SHL:pr2R("shl"); break;
		case SHR:pr2R("shr"); break;
		case LDX:printf("ld r%d +r%d r%d",IRr1(),IRr2(),IRr3()); break;
		case STX:printf("st +r%d r%d r%d",IRr2(),IRr3(),IRr1()); break;
		case JR: printf("jr r%d",IRr1()); break;
		case TRAP:printf("trap %d r%d",IRr1(),IRr2()); break;
		}
		break;
	default: printf("unknown op code");
	}
}

void show(){		/* show some registers */
  int i;
  printf("PC%4d ",savePc);
  disassem();
  printf("\tZ%d S%d ",Z,S);
  for(i=1;i<7;i++) printf("R%d:%d ",i,R[i]);
  printf("R31:%d\n",R[31]);
}
