
/* S2 cpu micro architecture simulator

   5 December 2001

   modify from s1 sim

   Computer Architecture 1997, 1998

   P. Chongstitvatana
   Department of Computer Engineering
   Chulalongkorn University

*/

#include "s2.h"

int R[32], Ir, Mdr, Mar, Pc, T, Z, S, M[20000];
int runflag, savePc;

void ifetch(){      	/* instruction fetch */
	Mar = Pc;
	Mdr = M[Mar]; Pc = Pc + 1;
}

void decode(){
	Ir = Mdr;
}

/* alu operation input : a, b
 affect condition code Z,S
 carry and overflow are not implemented */

int alu(char op, int a, int b){
  int t;
  switch(op) {
  case '+': t = a + b; break;
  case '-': t = a - b; break;
  case '*': t = a * b; break;
  case '/': t = a / b; break;
  case '&': t = a & b; break;
  case '|': t = a | b; break;
  case '^': t = a ^ b; break;
  case '<': t = a << 1; break;
  case '>': t = a >> 1; break;
  }
  if( t == 0 ) Z = 1; else Z = 0;
  if( t < 0 )  S = 1; else S = 0;
  return t;
}

int adder(int a, int b){
	return a + b;
}

int testCc(int cond ){	/* test condition code */
  switch( cond ){
  case ALWAYS: return 1;
  case EQ: return Z;
  case NEQ: return Z == 0;
  case LT: return S && (Z == 0);
  case LE: return S || Z;
  case GE: return (S == 0) || Z;
  case GT: return (S == 0) && (Z == 0);
  default: error("undefine conditional code");
  }
  return 0;
}

void wR(int rn, int value){    /* write register, check for R[0] */
	if(rn != 0) R[rn] = value;
}

void opRR(char op){
	T = alu(op,R[IRr2()],R[IRr3()]);
	wR(IRr1(),T);
}

void opRI(char op){
	T = alu(op,R[IRr2()],IRdisp());
	wR(IRr1(),T);
}

void countclock();
void xop();
void show();
void trap();

void run(){		// execute one instruction
	savePc = Pc;
    ifetch();
	decode();
    countclock();
    switch( IRop() ) {
    case LDA:
		Mar = IRads();
		Mdr = M[Mar];
	    wR(IRr1(),Mdr);
	    break;
	case LDD:
//		T = alu('+',R[IRr2()],IRdisp());
//		Mar = T;
		Mar = adder(R[IRr2()],IRdisp());  // not affect flag
		Mdr = M[Mar];
		wR(IRr1(),Mdr);
		break;
	case LDI:
		wR(IRr1(),IRdisp());
		break;
	case STA:
		Mar = IRads();
		Mdr = R[IRr1()];
		M[Mar] = Mdr;
	    break;
	case STD:
//		T = alu('+',R[IRr2()],IRdisp());
//		Mar = T;
		Mar = adder(R[IRr2()],IRdisp());
		Mdr = R[IRr1()];
		M[Mar] = Mdr;
		break;
    case JMP:
		if( testCc(IRr1()) )
			Pc = IRads();
	    break;
	case JAL:
		wR(IRr1(),Pc);
		Pc = IRads();
		break;
	case ADDI: opRI('+'); break;
	case SUBI: opRI('-'); break;
	case MULI: opRI('*'); break;
	case DIVI: opRI('/'); break;
	case ANDI: opRI('&'); break;
	case ORI:  opRI('|'); break;
	case XORI: opRI('^'); break;
	case XOP: xop(); break;   /* extended op */
    default: error("undefine op");
	}
}

void xop(){
	switch( IRxop() ) {
	case ADD: opRR('+'); break;
	case SUB: opRR('-'); break;
	case MUL: opRR('*'); break;
	case DIV: opRR('/'); break;
	case AND: opRR('&'); break;
	case OR:  opRR('|'); break;
	case XOR: opRR('^'); break;
	case SHL: opRR('<'); break;
	case SHR: opRR('>'); break;
	case LDX:
//		T = alu('+',R[IRr2()],R[IRr3()]);
//		Mar = T;
		Mar = adder(R[IRr2()],R[IRr3()]); // not affect flag
		Mdr = M[Mar];
		wR(IRr1(),Mdr);
		break;
	case STX:
//		T = alu('+',R[IRr2()],R[IRr3()]);
//		Mar = T;
		Mar = adder(R[IRr2()],R[IRr3()]);
		Mdr = R[IRr1()];
		M[Mar] = Mdr;
		break;
	case JR: Pc = R[IRr1()]; break;
	case TRAP: trap(IRr1(),IRr2()); break;
	default: error("undefine op");
	}
}

extern int clock, ninst;
void loadprogram(char *s);
void interp();

void main(int argc, char *argv[]){
  if( argc < 2 ) {
    printf("usage : s2 objfile\n");
    exit(0);
  }
  loadprogram(argv[1]);
  clock = 0;
  ninst = 0;
  Pc = 0;
  Z = 0;
  S = 0;
  R[0] = 0;
  runflag = 1;
  interp();
}

