/* as2.h   30 November 2001
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define LD 0		// op code number
#define ST 1
#define JMP 2
#define JAL 3
#define JR 4
#define ADD 5
#define SUB 6
#define MUL 7
#define DIV 8
#define AND 9
#define OR 10
#define XOR 11
#define SHL 12
#define SHR 13
#define TRAP 14
#define XL 15
#define XD 16
#define XX 17

#define ABS 20		// addressing modes
#define DISP 21
#define INX 22
#define IMM 23
#define RR 24
#define RI 25
#define SP 26
#define NA 27
#define EL 28      /* extended instuction */
#define ED 29
#define EX 30

#define SYM 40		// type of symbol
#define NUM 41
#define OP 42
#define DOTA 43
#define DOTC 44
#define DOTW 45
#define DOTE 46


#define UNDEF 0x80000000	/* max neg int, denote undef in sym tab */

#define	MXBUF	200			/* max input line length */
#define MXMEM	5000		/* max no of token */

typedef struct { char type; char mode; int ref; int line; } token;

/* hash symbol table functions from hash.c */
int searchsym(char *s);
int putsym(char *s, int value);
int getsym(char *s);
void putvalue(int idx, int value);
int getvalue(int idx);
