/* hash.c
   symbol table routines	26 July 98

   int hash(char *s)
   void putsym(char *s, int value)  // not guarantee unique symbol
   int getsym(char *s)
   int searchsym(char *s)
   void putvalue(int idx, int value)
   int getvalue(int idx)

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define LOCAL static
#define TSIZE 7919	/* must be next prime double num. of sym. */

struct 	{
  char name[32];
  int value;
} htable[TSIZE];	/* symbol table */
int 	nsym = 0;	/* number of symbol in hash table */

LOCAL int hash( char *name )	/* simple hash func. */
{
  int i, idx;
  for( idx=0, i=0; name[i] != 0; i++ )
    idx += name[i];
  return idx % TSIZE;
}

int putsym( char *name, int value)
{
  int idx;
  nsym++;			/* table full at TSIZE / 2 */
  if( nsym > TSIZE/2 ) {
    printf("too many symbols. increase table size\n");
    exit(0);
  }
  idx = hash(name);
  while( *htable[idx].name != 0 )
    idx = (idx + 1) % TSIZE;
  strcpy(htable[idx].name, name);
  htable[idx].value = value;
  return idx;
}

int getsym( char *name)		/* return -1 if not found */
{
  int idx;
  idx = hash(name);
  while( strcmp(htable[idx].name, name) != 0 ) {
    if(*htable[idx].name == 0 ) return -1;
    idx = (idx + 1) % TSIZE;
  }
  return htable[idx].value;
}

void dumpsymbol()     /* for debugging purpose */
{
  int i;
  for(i=0; i<TSIZE; i++)
    if( isalpha(htable[i].name[0]) )
      printf("%s %d\n",htable[i].name, htable[i].value);
}

int searchsym(char *name){	/* return index, -1 if not found */
  int idx;
  idx = hash(name);
  while( strcmp(htable[idx].name, name) != 0 ) {
    if(*htable[idx].name == 0 ) return -1;
    idx = (idx + 1) % TSIZE;
  }
  return idx;
}

void putvalue(int idx, int value){
	htable[idx].value = value;
}

int getvalue(int idx){
	return htable[idx].value;
}

