/* ----------------------------------------------------------------------------
  onemax.C
  Prabhas Chongstitvatana    17 Nov 2012

 DESCRIPTION:
   Example program for the SimpleGA class and 1DBinaryStringGenome class.
   The problem is called "Onemax".  Ga searches for string of all 1's. 

  This example uses the default crossover (single point), default mutator
(uniform random bit flip), and default initializer (uniform random) 

---------------------------------------------------------------------------- */
#include <ga/ga.h>

#define cout STD_COUT

float Objective(GAGenome &);	// This is the declaration of our obj function.

int main(int argc, char **argv)
{

// See if we've been given a seed to use (for testing purposes).  When you
// specify a random seed, the evolution will be exactly the same each time
// you use that seed number.

  for(int ii=1; ii<argc; ii++) {
    if(strcmp(argv[ii++],"seed") == 0) {
      GARandomSeed((unsigned int)atoi(argv[ii]));
    }
  }

// Declare variables for the GA parameters and set them to some default values.

  int width    = 10;
  int popsize  = 30;
  int ngen     = 100;
  float pmut   = 0.001;
  float pcross = 0.9;

// Now create the GA and run it.  First we create a genome of the type that
// we want to use in the GA.  The ga doesn't operate on this genome in the
// optimization - it just uses it to clone a population of genomes.

  GA1DBinaryStringGenome genome(width, Objective);

// Now that we have the genome, we create the genetic algorithm and set
// its parameters - number of generations, mutation probability, and crossover
// probability.  And finally we tell it to evolve itself.

  GASimpleGA ga(genome);
  ga.populationSize(popsize);
  ga.nGenerations(ngen);
  ga.pMutation(pmut);
  ga.pCrossover(pcross);
  ga.evolve();

// Now we print out the best genome that the GA found.

  cout << "The GA found:\n" << ga.statistics().bestIndividual() << "\n";

  return 0;
}


// This is the objective function.  

float Objective(GAGenome& g) {
  GA1DBinaryStringGenome & genome = (GA1DBinaryStringGenome &)g;
  float score=0.0;
  for(int i=0; i<genome.length(); i++){
    if(genome.gene(i) == 1)
	  score += 1.0;
  }
  return score;
}
