// COIN for TSP
//    written by Supawadee Srikumdee	7 April 2018


#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define N 15                    //the number of cities
#define MAX_GEN 2000            //maximum generation
#define POPSIZE 200             //population size
#define perG 0.3                //percentage of good candidates
#define perB 0.3                //percentage of poor candidates
#define l_r 0.01                //learning step
#define fileData "input15.txt"  // data for run

int intrnd (void); 				// function prototype
double rand_0to1(void);

FILE *fpOutput;
double  seed;
struct population
{
    int chrome[N];
    int fitness;
}p[POPSIZE];


void readData(int city[N][N]){
    FILE *fp ;
    int i,j;

    fp = fopen(fileData,"r");
	if(fp == NULL){
        printf("Error open file input\n");
        exit(0);
    }else{
    	for(i = 0 ; i< N ; i++){
            for(j=0;j<N;j++) {
                fscanf(fp,"%d ",&city[i][j]);
            }
        }
		fclose(fp);
    }
}
//The generator matrix of COIN stores the probability of incidences of subsequences found in the candidates.
//Each probability in each row is equal to 1/(n-1), where n is the size of the problem.
void initialModel(double gM[N][N]){
    int i,j;

    for(i=0;i<N;i++){
        for(j=0;j<N;j++){
            if(i!=j){
                gM[i][j] = 1.0/(N-1);
            }else{
                gM[i][j] = 0;
            }
        }
    }
}
//display information in generator matrix
void printModel(double gM[N][N]){
    int i,j;
    double sum;

    for(i=0;i<N;i++){
        sum = 0;
        for(j=0;j<N;j++){
            fprintf(fpOutput,"%.2f ",gM[i][j]);
            sum += gM[i][j];
        }
        fprintf(fpOutput,"\n");
        //fprintf(fpOutput,"[%.2f]\n",sum);
    }
}
//display information in population
void printPopulation(){
    int i,j;

    for(i=0;i<POPSIZE;i++){
        fprintf(fpOutput,"c%d fit %d : ",i,p[i].fitness);
        for(j=0;j<N;j++){
            fprintf(fpOutput,"%d ",p[i].chrome[j]);
        }
        fprintf(fpOutput,"\n");
    }
}
/*park-miller.cc   Park-Miller random number generator
 W. Langdon cs.ucl.ac.uk 5 May 1994*/
int intrnd (void){ /* 1<=seed<=m */
	double const a    = 16807;      /* ie 7**5 */
	double const m    = 2147483647; /* ie 2**31-1 */
	double temp = seed * a;

   seed = (int) (temp - m * (int)( temp / m ));

   return seed;
}

double rand_0to1(void){
	return (double)(intrnd()) / 2147483647.0;
}

// Each candidate is sampled from the generator matrix.
void sampleCandidate(int cId, double gM[N][N]){
    int i,j,r,a;
    double tmp[N][N];
    double sumProb;
    double rD;
    int c_len = 0; //chromosome length
    int id[N];
    int nId;

    //copy gM to tmp , tmp is note.
    for(i=0;i<N;i++){
        for(j=0;j<N;j++){
            tmp[i][j] = gM[i][j];
        }
    }

    //the first element can be anything
    r = intrnd()%N;
    p[cId].chrome[c_len] = r + 1;// the number of city start with 1 , r start with index 0
    c_len++;//update the length of the chromosome

    //other elements based on elements that are selected.
    while(c_len < N){
        //The selected item is not selected, mark that item with -1
        for(i=0;i<N;i++){
            tmp[i][r] = -1;
        }

        //random one element based on its probability
        sumProb = 0;
        nId = 0;
        for(i=0;i<N;i++){
            if(tmp[r][i] != -1 && i!= r){
                sumProb += tmp[r][i];
                id[nId] = i;
                nId++;
            }
        }
        //random a value in range [0, sumProb]
        rD = rand_0to1()*sumProb;

        //find id of that random value.
        sumProb = 0;
        a = id[0];
        for(i=0;i<nId;i++){
            sumProb += tmp[r][id[i]];
            if(rD <= sumProb){
                //fprintf(fpOutput,"select %d\n",id[i]+1);
                a = id[i];
                i = nId;
            }
        }

        //add that element to the chromosome
        p[cId].chrome[c_len] = a+1;
        c_len++;
        r = a;
    }

}
void samplePopulation(double gM[N][N]){
    int i;

    for(i=0;i<POPSIZE;i++){
        sampleCandidate(i,gM);
    }
}
int evaluateCandidate(int cId, int city[N][N]){
    int sum = 0;
    int i,a,b;

    for(i=0;i<N-1;i++){
        //distant from city a to city b
        a = p[cId].chrome[i];
        b = p[cId].chrome[i+1];
        sum += city[a-1][b-1];
    }
    //distance from the last city back to the first city
    a = p[cId].chrome[N-1];
    b = p[cId].chrome[0];
    sum += city[a-1][b-1];

    //fprintf(fpOutput,"fitness is %d\n",sum);
    return sum;
}
//ascending order
void sortCandidate(int fit[POPSIZE][2]){
    int h,m,j,i;
    int tmp[2];
    for(h=POPSIZE/2 ; h >=1 ; h = h /2){
        for(m=0 ; m < h ; m++){
            for(j = h+m; j <POPSIZE ; j= j+h){
                tmp[0] = fit[j][0];//keep value
                tmp[1] = fit[j][1] ;//keep index
                for(i=j-h; i>=0 ; i=i-h){
                    if(tmp[0] >= fit[i][0]) {
                        break;
                    }
                    fit[i+h][0] = fit [i][0];
                    fit[i+h][1] = fit [i][1];
                }
                fit[i+h][0] = tmp[0];
                fit[i+h][1] = tmp[1];
            }
        }
    }
}
//classify good and poor candidate and assign them to good[] and poor[] (keep candidate id)
void selectCandidate(int Ngood,int good[Ngood],int Npoor,int poor[Npoor]){
    int i;
    int fit[POPSIZE][2];

    //sort candidates based on its fitness by ascending order
    for(i=0;i<POPSIZE;i++){
        fit[i][0] = p[i].fitness; //fitness value
        fit[i][1] = i;//candidate id
    }
    sortCandidate(fit);

    //classify good candidate and poor candidate
    for(i=0;i<Ngood;i++){
        good[i] = fit[i][1];
        poor[i] = fit[POPSIZE-1-i][1];
    }
}
void punishCandidate(int cId, int r, int c,double gM[N][N]){
    int i;
    double rw = l_r/(N-1);
    double sum;

    //gM[r][c] is poor element, it was punish by decrease its probability equals l_r to other element in row r

    //If probability of gM[r][c] is less than penalty, scaling it.
    if(gM[r][c] < l_r){
        rw = gM[r][c]/(N-1);
    }

    //other elements except itself are increased probability equal to rw
    for(i=0;i<N;i++){
        if(i != c && i!= r){
            gM[r][i] += rw;
            //if the probability is more than 1, adjust it.
            if(gM[r][i] > 1){
                gM[r][i] = 1;
            }
        }
    }

    //decrease probability of gM[r][c]. If its prob less than 0, adjust it.
    gM[r][c] -= rw*(N-1);
    if(gM[r][c] < 0){
        gM[r][c] = 0;
    }

    //Each row has totally probability summed up to 1. Check and scaling them
    sum =0;
    for(i=0;i<N;i++){
        sum += gM[r][i];
    }
    if(sum != 1){
        for(i=0; i< N ;i++){
            gM[r][i] /= sum;
        }
    }
    /*fprintf(fpOutput,"after update\n");
    for(i=0;i<N;i++){
        fprintf(fpOutput,"%.2f ",gM[r][i]);
    }
    fprintf(fpOutput,"\n");*/
}
void rewardCandidate(int cId, int r, int c,double gM[N][N]){
    int i;
    double sum_reward = 0;
    double rw = l_r/(N-1);
    double sum;

    /*gM[r][c] is good element, it was rewarded by increase its probability equals l_r
    by decrease other elements in row r*/

    //other elements except itself are decreased probability equal to rw
    for(i=0;i<N;i++){
        if(i != c && i!= r){
            //if punishment not exceed its prob, can be decreased equal rw
            if(gM[r][i] > rw){
                gM[r][i] -= rw;
                sum_reward += rw;
            }else{//otherwise, decreased equal current prob
                sum_reward += gM[r][i];
                gM[r][i] = 0;
            }
        }
    }

    //increase probability of gM[r][c]. If its prob is more than 1, adjust it.
    gM[r][c] += sum_reward;
    if(gM[r][c] > 1){
        gM[r][c] = 1;
    }

    //Each row has totally probability summed up to 1. Check and scaling them
    sum =0;
    for(i=0;i<N;i++){
        sum += gM[r][i];
    }
    //fprintf(fpOutput,"after update row %d has sum prob = %.2f\n",r,sum);
    if(sum != 1){
        for(i=0; i< N ;i++){
            gM[r][i] /= sum;
        }
    }
    /*fprintf(fpOutput,"after update\n");
    for(i=0;i<N;i++){
        fprintf(fpOutput,"%.2f ",gM[r][i]);
    }
    fprintf(fpOutput,"\n");*/

}
//The good solutions found in the population are used to bias the generator through rewarding.
//The poor solutions are used to bias the generator through punishment.
void updateModel(int Ngood,int good[Ngood],int Npoor,int poor[Npoor],double gM[N][N]){
    int i,j,r,c;
    int cId;

    //rewarding by good candidates
    for(i=0;i<Ngood;i++){
        cId = good[i];
        //Each candidate is factorized in to smaller building blocks (size = 2).
        for(j=0;j<N-1;j++){
            r = p[cId].chrome[j]-1;
            c = p[cId].chrome[j+1]-1;

            //reward generator matrix row r, col c
            rewardCandidate(cId,r,c,gM);
        }
        r = p[cId].chrome[N-1]-1;
        c = p[cId].chrome[0]-1;
        rewardCandidate(cId,r,c,gM);
    }

    //punishment by poor candidates
    for(i=0;i<Npoor;i++){
        cId = poor[i];
        //Each candidate is factorized in to smaller building blocks (size = 2).
        for(j=0;j<N-1;j++){
            r = p[cId].chrome[j]-1;
            c = p[cId].chrome[j+1]-1;

            //punish generator matrix row r, col c
            punishCandidate(cId,r,c,gM);
        }
        r = p[cId].chrome[N-1]-1;
        c = p[cId].chrome[0]-1;
        punishCandidate(cId,r,c,gM);
    }
}

int main(void){
    int city[N][N];
    double gM[N][N];//generator matrix
    int i,j,gen;
    time_t current_time;
    int Ngood = POPSIZE*perG;
    int Npoor = POPSIZE*perB;
    int good[Ngood];
    int poor[Npoor];
    int elite[N+1];//[0] keeps fitness of the best solution , [1-N] keep the number of cities were traversed.

    elite[0] = 10000;

    fpOutput = fopen("result.txt","w+");//The results are writed in this file
    current_time = time(NULL);//use time as seed for random
    seed = current_time;

    //0. preparation information of the problem
    readData(city);
    //printData(city);

    //1.initial model
    initialModel(gM);
    fprintf(fpOutput,"initial model =====>\n");
    printModel(gM);

    //2-5 are repeated until terminated (pre-defined max generation)
    for(gen=0;gen<MAX_GEN;gen++){
        //2.sample population
        samplePopulation(gM);

        //3.evaluate population
        for(j=0;j<POPSIZE;j++){
            p[j].fitness = evaluateCandidate(j,city);
        }
        //printPopulation();

        //4.select candidate
        selectCandidate(Ngood,good,Npoor,poor);
        /*fprintf(fpOutput,"Good candidate : ");
        for(i=0;i<Ngood;i++){
            fprintf(fpOutput,"%d ",good[i]);
        }
        fprintf(fpOutput,"\n");

        fprintf(fpOutput,"Poor candidate : ");
        for(i=0;i<Npoor;i++){
            fprintf(fpOutput,"%d ",poor[i]);
        }
        fprintf(fpOutput,"\n");*/

        //5. update the model
        updateModel(Ngood,good,Npoor,poor,gM);

        //update elite
        if(p[good[0]].fitness < elite[0]){
            elite[0] = p[good[0]].fitness;
            for(i=0;i<N;i++){
                elite[i+1] = p[good[0]].chrome[i];
            }
        }

        //for input15.txt optimal solution = 291
        if(elite[0] == 291){
            printf("The algorithm found optimal solution, terminate in gen %d!!!\n",i);
            gen = MAX_GEN;
        }

        //for input26.txt optimal solution = 937
        /*if(elite[0] == 937){
            printf("The algorithm found optimal solution, terminate in gen %d!!!\n",i);
            gen = MAX_GEN;
        }*/
    }
    fprintf(fpOutput,"Finally, the generator matrix =====>\n");
    printModel(gM);

    printf("The best result is %d\ntraverse : ",elite[0]);
    fprintf(fpOutput,"The best result is %d\ntraverse : ",elite[0]);
    for(i=1;i<=N;i++){
        printf("%d ",elite[i]);
        fprintf(fpOutput,"%d ",elite[i]);
    }
    printf("\n");
    fprintf(fpOutput,"\n");

    return 0;
}

void printData(int city[N][N]){
    int i,j;

    for(i=0;i<N;i++){
        for(j=0;j<N;j++){
            fprintf(fpOutput,"%d ",city[i][j]);
        }
        fprintf(fpOutput,"\n");
    }
}

