#ifndef ET_SERVO_h
#define ET_SERVO_h

#include <inttypes.h>

class ET_SERVO
{  
  public:
    ET_SERVO();
    int attach(int);       					//Connect Servo Pin with Pulse Length 1000uS..2000uS                          
    int attach(int, unsigned int, unsigned int); 	//Connect Servo Pin with Pulse Length min_pulse..max_pulse                             		
    void detach();						//Disconnect Servo Pin
    int attached();						//Verify Servo Connect
    void updateDutyCycle(unsigned int);			//Update Duty Cycle
    unsigned int readDutyCycle();				//Read Duty Cycle    
    void modifyServoForward();				//Forward  Modify  Servo(2mS)
    void modifyServoBackward();				//Backward Modify Servo(1mS)
    void modifyServoStop();					//Stop Modify Servo("1":20mS)
    void setMinPulse(unsigned int);				//Min Pulse length in microseconds(Default 1000uS:1mS)
    void setMaxPulse(unsigned int);				//Max Pulse length in microseconds(Default 2000uS:2mS)

  private:
    int pin;							//Pin Connect Servo
    unsigned int dutycycle;    				//DutyCycle = 1uS Unit
    unsigned int minpulse;     				//Minimum Pulse(Default = 1000uS)  
    unsigned int maxpulse;     				//Maximum Pulse(Default = 2000uS)
    static void seizeTimer1();				//Config Start Timer1 Generate Pulse Control Servo
    static void releaseTimer1();				//Release Timer1 From Servo Control
    static int attached9;					//Status Digital-9 Connect  Servo
    static int attached10;					//Status Digital-10 Connect Servo
};

#endif
