/* data.c  data structure for nut.c

	separate memory to code (heap),data (mem) segment	15 June 2006
*/

#include "nut.h"

#define PRIVATE		static

int mem[MEMMAX];		// data segment
int DP = 0;				// data pointer
int heap[HEAPMAX];		// code segment
int heapFree = 2;		// code pointer

extern void error(char *s);

// --------- data structure ops  --------

// allocate from code segment
int new(int size){
	int p;
	if( heapFree >= HEAPMAX - 5)
		error("out of heap memory");
	p = heapFree;
	heapFree += size;
	return p;
}

// allocate one item from data segment
int newdata(void){
	int a;
	if( DP >= MEMMAX)
		error("out of memory");
	a = DP;
	DP++;
	return a;
}

// bit 31 = 1, bit 30..24 = op, bit 23..0 = arg
exp mkATOM(int op, int arg){
	return (exp)(0x80000000 | (op<<24) | (arg & 0x0ffffff));
}

// make strin, alloc from data segment
int mkSTR(char *s){
	int s2;
	s2 = DP;
	while( *s != 0 ){
		mem[newdata()] = *s & 255;
		s++;
	}
	mem[newdata()] = 0;
	return s2;
}

// ------- out obj file ---------

// format: main-ads last (ads type op arg next)*
// ads starts at 2
void outobj(char *fn){
	FILE *fp;
	int i, h, ty, op, arg, idx;
	fp = fopen(fn,"wt");
	idx = install("main");
	// out code segment
	fprintf(fp,"%d %d\n",symtab[idx].val,heapFree-2);
	for(i=2; i<heapFree; i+=2){
		h = heap[i];
		ty = isAtom(h) ? 1 : 0;
		op = (h >> 24) & 0x07f;
		arg = h & 0x0ffffff;
		fprintf(fp,"%d %d %d %d %d\n",
			i,ty,op,arg,heap[i+1]);
	}
	// out data segment
	fprintf(fp,"%d\n",DP);
	for(i=0; i<DP; i++){
		fprintf(fp,"%d ",mem[i]);
		if( (i%5) == 0) fprintf(fp,"\n");
	}
	fprintf(fp,"\n");
	dumpsymtab(fp);
	fclose(fp);
}

// ------ print non-lin machine code --------

PRIVATE void pA1(char *s){ printf("%s ",s); }
PRIVATE void pA2(char *s, int v){ printf("%s.%d ",s,v); }

PRIVATE void prAtom( exp e){
	int op,arg;
	op = (e >> 24) & 0x7f;
	arg = e & 0x0ffffff;
	switch(op){
	case  xIF: pA1("if"); break;
	case  xWHILE: pA1("while"); break;
	case  xDO: pA1("do"); break;
	case  xNEW: pA1("new"); break;
	case  xADD: pA1("+"); break;
	case  xSUB: pA1("-"); break;
	case  xMUL: pA1("*"); break;
	case  xDIV: pA1("/"); break;
	case  xBAND: pA1("&"); break;
	case  xSHR: pA1(">>"); break;
	case  xSHL: pA1("<<"); break;
	case  xEQ: pA1("="); break;
	case  xLT: pA1("<"); break;
	case  xGT: pA1(">"); break;
	case  xCALL: pA2("call",arg); break;
	case  xGET: pA2("get",arg); break;
	case  xPUT: pA2("put",arg); break;
	case  xLIT: pA2("lit",arg); break;
	case  xLDX: pA2("ldx",arg); break;
	case  xSTX: pA2("stx",arg); break;
	case  xLD: pA2("ld",arg); break;
	case  xST: pA2("st",arg); break;
	case  xLDY: pA2("ldy",arg); break;
	case  xSTY: pA2("sty",arg); break;
	case  xFUN:	printf("fun.%d.%d ",arg>>8,arg&0x0ff); break;
	case  xSYS: pA2("sys",arg); break;
	case  xSTR: pA2("str",arg); break;
	}
}

PRIVATE void prL2(exp e){
	if( e == NIL ) return;
	if( isAtom(e) )
		prAtom(e);
	else{
		prList(head(e));
		prL2(tail(e));
	}
}

void prList( exp e){
	if( e == NIL ) return;
	if( isAtom(e) )
		prAtom(e);
	else{
		printf("(");
		prL2(e);
		printf(")");
	}
}
/* an example how to do processing of list of list
int lenList( exp e){
	if( e == NIL ) return 0;
	if( isAtom(e) ) return 1;
	return lenList(head(e)) + lenList(tail(e));
}
*/
