/* nut.h
	add LD ST LDY STY		4 Jan 2005
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define HEAPMAX	  100000	// code segment
#define MEMMAX    10000		// data segment
#define NAMELEN   32
#define MAXNAMES  1000
#define MAXFIN    50000

#define DELIM "() \t\n"
#define EOF_CHAR 127	// be careful, char is signed
#define NIL   0

// builtinop
#define xIF 1
#define xWHILE 2
#define xDO 3
#define xNEW 5
#define xADD 6
#define xSUB 7
#define xMUL 8
#define xDIV 9
#define xEQ 10
#define xLT 11
#define xGT 12
#define xCALL 13
#define xGET 14
#define xPUT 15
#define xLIT 16
#define xLDX 17
#define xSTX 18
#define xFUN 19
#define xSYS 20
#define ySET 21		// keyword
#define ySETV 22	// keyword
#define yVEC 23		// keyword
//#define yLET 24		// keyword
#define xLD 25
#define xST 26
#define xLDY 27
#define xSTY 28
//#define ySEM 29
//#define yMAC 30		// macro def
//#define yMX 31		// macro expansion
#define xSTR 32
#define xBAND 33
#define xSHR 34
#define xSHL 35

#define tyATOM 1
#define tyDOTP 0
#define tyVAR 2
#define tyFUN 3
#define tyOP 4
#define tyOPX 5
#define tySYS 6
#define tyUD 7   // undefined
#define tyGVAR 8
#define tyMAC 9
#define tyENUM 10

typedef int exp;
typedef char namestr[NAMELEN];
typedef struct{
	namestr name;
	int type;
	int val;
	int arity;
	int lv;
} symrec;

// string equality
#define eqs(a,b) (strcmp((a),(b))==0)

extern symrec symtab[];
extern int heap[];

//  list constructor
#define head(e)  		heap[(e)]
#define tail(e)  		heap[(e)+1]
#define sethead(e,v)	heap[(e)] = v
#define settail(e,v)	heap[(e)+1] = v

#define nl()	printf("\n");

// function prototype

exp parseExp(void);			// nut.c
int isAtom(exp e);
int install(namestr nm);
void dumpsymtab(FILE *fo);
void error( char *mess );

int new(int size);			// data.c
int newdata(void);
exp mkATOM(int op, int arg);
void prList( exp e);
void outobj(char *fn);
int mkSTR(char *s);

