/* data.c  data structure for nut.c

*/

#include "nut2.h"

int heapFree = 2;

extern void error(char *s);

/* data structure ops */

int new(int size){
	int p;
	if( heapFree >= MEMMAX - 5)
		error("out of memory");
	p = heapFree;
	heapFree += size;
	return p;
}

// bit 31 = 1, bit 30..24 = op, bit 23..0 = arg
PRIVATE exp mkcell(int ty, int op, int arg){
	return (exp)( (ty<<31) | (op<<24) | (arg & 0x0ffffff));
}

// compute k and fs and recode fun.a.v to fun.k.fs
// relocate DS
PRIVATE void recode(int start, int end){
	int i, op, arg, arity, fs, k;
	for(i=start; i<=end; i+=2){
		decode(M[i],&op,&arg);
		switch(op){
		case xFUN:
			arity = (arg >> 8) & 0x0ff;
			fs = (arg & 0x0ff) + 1;
			k = fs - arity;
			arg = (k << 8) | fs;
			M[i] = mkcell(1,op,arg);
			break;
		case xLD: 	// GVAR relocate DS to behind code
		case xST:	// at end+2
		case xLDY:
		case xSTY:
		case xSTR:
			M[i] = mkcell(1,op,end+2+arg);
			break;
		}
	}
}

int loadobj(char *fn){
	int start, last, len, i, ads, ty, op, arg, nxt, ds;
	FILE *fi;
	fi = fopen(fn,"r");
	fscanf(fi,"%d %d",&start,&last);
	i = 0;
	do{
		fscanf(fi,"%d %d %d %d %d",&ads,&ty,&op,&arg,&nxt);
		M[ads] = mkcell(ty,op,arg);
		M[ads+1] = nxt;
		if( i == 0) i = ads;	// first ads
	}while (ads < last);
	recode(i,last);
	ds = last + 2;
	fscanf(fi,"%d",&len);
	for(i=ds; i<ds+len; i++){
		fscanf(fi,"%d",&arg);
		M[i] = arg;
	}
	fclose(fi);
	heapFree = ds+len;
	return start;
}

// ------ print non-lin machine code --------

PRIVATE void pA1(char *s){ printf("%s ",s); }
PRIVATE void pA2(char *s, int v){ printf("%s.%d ",s,v); }

PRIVATE void prAtom( exp e){
	int op,arg;
	op = (e >> 24) & 0x7f;
	arg = e & 0x0ffffff;
	switch(op){
	case  xIF: pA1("if"); break;
	case  xWHILE: pA1("while"); break;
	case  xDO: pA1("do"); break;
	case  xNEW: pA1("new"); break;
	case  xADD: pA1("+"); break;
	case  xSUB: pA1("-"); break;
	case  xMUL: pA1("*"); break;
	case  xDIV: pA1("/"); break;
	case  xBAND: pA1("&"); break;
	case  xSHR: pA1(">>"); break;
	case  xSHL: pA1("<<"); break;
	case  xEQ: pA1("="); break;
	case  xLT: pA1("<"); break;
	case  xGT: pA1(">"); break;
	case  xCALL: pA2("call",arg); break;
	case  xGET: pA2("get",arg); break;
	case  xPUT: pA2("put",arg); break;
	case  xLIT: pA2("lit",arg); break;
	case  xLDX: pA2("ldx",arg); break;
	case  xSTX: pA2("stx",arg); break;
	case  xLD: pA2("ld",arg); break;
	case  xST: pA2("st",arg); break;
	case  xLDY: pA2("ldy",arg); break;
	case  xSTY: pA2("sty",arg); break;
	case  xSTR: pA2("str",arg); break;
	case  xFUN:
		printf("fun.%d.%d ",arg>>8,arg&0x0ff);
		break;
	case  xSYS: pA2("sys",arg); break;
	}
}

PRIVATE void prL2(exp e){
	if( e == NIL ) return;
	if( isAtom(e) )
		prAtom(e);
	else{
		prList(head(e));
		prL2(tail(e));
	}
}

void prList( exp e){
	if( e == NIL ) return;
	if( isAtom(e) )
		prAtom(e);
	else{
		printf("(");
		prL2(e);
		printf(")");
	}
}

