/* eval3.c
	 5 Jan 2005

	sys 3, 9, 10, 11, 12 are specific to nut-in-nut compiler
	sys 3	tokenise
	sys 9	get heapFree
	sys 10	print readable n-code
	sys 11	read stdin into inbuf[]
	sys 12	print source line number
	22 June 2006
 */

#include "nut2.h"

extern namestr token;	// current token
extern int line;		// current source line

int M[MEMEND];
int sp = STKBASE;		// M = heap : SS
int fp = STKBASE;
int tok;

void push(exp a){
	sp++;
	if(sp >= MEMEND ) error("stack overflow");
	M[sp] = a;
}

exp head(exp e){
	if( e == NIL) return NIL;
	if( e < 0 || e >= MEMMAX )
		error("access memory out of bound");
	return M[e];
}

exp tail(exp e){
	if( e == NIL) return NIL;
	if( e < 0 || e >= MEMMAX )
		error("access memory out of bound");
	return M[e+1];
}

int isAtom(exp e){
	return (e & 0x80000000) != 0;
}

void decode(exp a, int *op, int *arg){
	*op = (a >> 24) & 0x07f;
	*arg = a & 0x0ffffff;
}

exp arg1(exp e){
	return head(e);
}

exp arg2(exp e){
	return head(tail(e));
}

exp arg3(exp e){
	return head(tail(tail(e)));
}

// -------- special routines -------

// copy C string to M[tok]
void copyToken(void){
	int i;
	i = 0;
	while(token[i] != 0){
		M[tok+i] = (int)token[i];
		i++;
	}
	M[tok+i] = 0;
}

// print nut string
void prstr(int a){
	while(M[a] != 0){
		printf("%c",M[a]);
		a++;
	}
}

// ------------------------

PRIVATE exp syscall(int arg, exp e){
	int a1, a2, a3, v;
	v = NIL;
	a1 = eval(arg1(e));
	switch(arg){
	case 1:	printf("%d",a1); break;
	case 2:	printf("%c",a1); break;
	case 3:
		tokenise();
		copyToken();
		v = tok;
		break;
	case 9: v = heapFree; break;
	case 10: prList(a1); break;
	case 11: readinfile(); break;
	case 12: printf(" line %d ",line); break;
	case 13: exit(0);	// halt
	default: error("undef sys");
	}
	return v;
}

int cnt = 0;

exp eval(exp e){
	int op, arg, arity, k, v;
	int idx, fs, e1;

	if (cnt++ > 100000000)
		error("infinite loop\n");

	if( e == NIL) return NIL;
	if( ! isAtom(e) ) {
		e1 = tail(e);			// argument list (arg1 arg2 ...)
		e = head(e);			// operator
	}
	decode(e,&op,&arg);
	switch(op){
	case xIF:
		if( eval(arg1(e1)) != 0)
			return eval(arg2(e1));
		else
			return eval(arg3(e1));
	case xWHILE:
		while( eval(arg1(e1)) )
			v = eval(arg2(e1));
		return v;
	case xDO:
		while( e1 != NIL ){
			v = eval(head(e1));
			e1 = tail(e1);
		}
		return v;			// return the last eval
	case xNEW: return new(eval(arg1(e1)));
	case xADD: return eval(arg1(e1)) + eval(arg2(e1));
	case xSUB: return eval(arg1(e1)) - eval(arg2(e1));
	case xMUL: return eval(arg1(e1)) * eval(arg2(e1));
	case xDIV: return eval(arg1(e1)) / eval(arg2(e1));
	case xBAND: return eval(arg1(e1)) & eval(arg2(e1));
	case xSHR: return eval(arg1(e1)) >> eval(arg2(e1));
	case xSHL: return eval(arg1(e1)) << eval(arg2(e1));
	case xEQ: return eval(arg1(e1)) == eval(arg2(e1)) ? 1 : 0;
	case xLT: return eval(arg1(e1)) < eval(arg2(e1)) ? 1 : 0;
	case xGT: return eval(arg1(e1)) > eval(arg2(e1)) ? 1 : 0;
	case xCALL:
		while( e1 != NIL ){	// eval all arg
			v = eval(head(e1));
			push(v);
			e1 = tail(e1);
		}
		return eval(arg);	// eval body of fun
	case xLIT: return arg;
	case xSTR: return arg;
	case xGET: return M[fp-arg];
	case xPUT:
		v = eval(arg1(e1));
		M[fp-arg] = v;
		return v;
	case xLDX:
		idx = eval(arg1(e1));
		return M[ M[fp-arg] + idx];
	case xSTX:
		idx = eval(arg1(e1));
		v = eval(arg2(e1));
		M[ M[fp-arg] + idx] = v;
		return v;
	case xLDY:
		idx = eval(arg1(e1));
		return M[M[arg] + idx];
	case xSTY:
		idx = eval(arg1(e1));
		v = eval(arg2(e1));
		M[M[arg] + idx] = v;
		return v;
	case xLD: return M[arg];
	case xST:
		v = eval(arg1(e1));
		M[arg] = v;
		return v;
	case xFUN:
		// fs, k should be compute by compiler
		// k = (arg & 0xff)-(arg >> 8)+1
	    // fs = (arg & 0xff)-1
//		arity = arg >> 8;
//		fs = arg & 0xff;
//		k = fs-arity+1;
		fs = arg & 0xff;
		k = arg >> 8;		// already recode
		M[sp+k] = fp;		// new frame
		fp = sp+k;
		sp = fp;
		v = eval(arg1(e1));
		sp = fp-fs;			// delete frame
		fp = M[fp];
		return v;
	case xSYS: return syscall(arg,e1);
	default:
		printf("%d ",op);
		error("unknown op\n");
	}
	return NIL;
}

