/* base.h  for  base.c   base interpreter
	8 October 2001
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define  PRIVATE	static

#define  MEMMAX    100000
#define  STACKMAX  10000

#define  MEMEND		(MEMMAX + STACKMAX)
#define  STKBASE	MEMMAX

#define NAMELEN   80
#define MAXNAMES  1000
#define MAXFIN    50000

#define DELIM "() \t\n"
//#define SPECIAL "()"
#define EOF_CHAR 127	// be careful, char is signed

#define NIL   0

// builtinop
#define xIF 1
#define xWHILE 2
#define xDO 3
#define xNEW 5
#define xADD 6
#define xSUB 7
#define xMUL 8
#define xDIV 9
#define xEQ 10
#define xLT 11
#define xGT 12
#define xCALL 13
#define xGET 14
#define xPUT 15
#define xLIT 16
#define xLDX 17
#define xSTX 18
#define xFUN 19
#define xSYS 20		// 21..24 keyword
#define xLD 25
#define xST 26
#define xLDY 27
#define xSTY 28
#define xSTR 32
#define xBAND 33
#define xSHR 34
#define xSHL 35

typedef int exp;
typedef char namestr[NAMELEN];

// string equality
#define eqs(a,b) (strcmp((a),(b))==0)

extern int M[];
extern int *DS;
extern int heapFree;

// memory model
//
//  M[      MEMMAX         |   STACKMAX ]
//   [code | DS  | heap    ]


#define nl()	printf("\n");

extern char token[];	// current token

// function prototype

int isAtom(exp e);
void decode(exp a, int *op, int *arg);
exp head(exp e);
exp tail(exp e);
void error(char *mess);
void push(exp a);

int new(int size);
void prList( exp e);
int loadobj(char *fn);

void tokenise(void);
void readinfile(void);
exp eval(exp e);
