/* token.c    lexical analyser, tokeniser
	extract from nut3 compiler
	for nut in nut		18 June 2006
*/

#include "nut2.h"

int line;				// current line
char *cp;				// current char
char inbuf[MAXFIN];		// input buffer
char token[200];		// current token

// read from stdin, redirect from a file
void readinfile(void) {
	int n;
	n = fread(inbuf,1,MAXFIN-2,stdin);
	inbuf[n] = EOF_CHAR;
	inbuf[n+1] = 0;
	cp = inbuf;
	line = 1;
}

PRIVATE int isSpecial(char c){
	return c == '(' || c == ')' || c == EOF;
}

PRIVATE int isBlank(char c){
	return c == 32 || c == '\t' || c == '\n' || c == ';';
}

// skip " \t\n;" and comment, counting line
PRIVATE char *skipblank(char *s){
	while( isBlank(*s)){
		if( *s == '\n') line++;
		if( *s == ';'){
			while( *s != '\n') s++;	// skip to eol
			line++;
		}
		s++;
	}
	return s;
}

// tok blank c<- c2+1 -> c+1+c2
//   ^---------^-----------^
//   leave pointer to next to the end of current token

void tokenise(void){
	int c2;
	cp = skipblank(cp);
	if( isSpecial(*cp)) {
		token[0] = *cp;
		token[1] = 0;
		cp++;
	}else if( *cp == '"'){			// string
		c2 = strcspn(cp+1,"\"");
		strncpy(token,cp,c2+1);
		token[c2+1] = 0;
		cp += c2+2;
	}else{							// name
		c2 = strcspn(cp+1,DELIM);
		strncpy(token,cp,c2+1);
		token[c2+1] = 0;
		cp += c2+1;
	}
//	printf("%s ",token);
}

